function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/RolesEditor
 */
define(['baja!', 'baja!baja:Role', 'bajaux/Widget', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/fe/baja/util/userUtils', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, types, Widget, $, Promise, _, CompositeEditor, spaceUtils, subscriberUtils, userUtils, CompositeBuilder) {
  'use strict';

  var MAX_ROLES = 10;
  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var resolveCurrentUser = userUtils.resolveCurrentUser;
  var getRoleService = leaseWhenNeeded(_.partial(resolveService, 'baja:RoleService'));
  /**
   * Editor for editing available roles on a user.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/RolesEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */

  var RolesEditor = function RolesEditor(params) {
    CompositeEditor.apply(this, arguments);
  };

  RolesEditor.prototype = Object.create(CompositeEditor.prototype);
  RolesEditor.prototype.constructor = RolesEditor;
  /**
   * @private
   * @param {baja.Component} [base]
   * @returns {Promise.<baja.Component>}
   */

  RolesEditor.prototype.$getRoleService = function (base) {
    return getRoleService(base);
  };
  /**
   * @private
   * @param {baja.Component} base
   * @returns {Promise.<baja.Component>}
   */


  RolesEditor.prototype.$getCurrentUser = function (base) {
    return resolveCurrentUser(base)["catch"](function () {
      return null;
    });
  };
  /**
   * Resolve the roles that are available to add to a user.
   *
   * @private
   * @returns {Promise.<Array.<String>>} promise to be resolved with an array
   * of role names
   */


  RolesEditor.prototype.$getAvailableRoles = function () {
    var _this = this;

    var that = this;
    return this.getOrdBase().then(function (base) {
      return Promise.all([_this.$getRoleService(base), _this.$getCurrentUser(base)]);
    }).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          roleService = _ref2[0],
          user = _ref2[1];

      var roleNames = _.map(roleService.getSlots().is('baja:IRole').toArray(), String); // remove all roles that don't belong to the logged in user.
      // super user can set any roles. If we couldn't find the user, just
      // show all, the station side check will prevent setting roles that
      // they aren't allowed.


      if (!user || user.get('permissions').isSuperUser()) {
        return roleNames;
      } // only add roles that were already assigned to the target user
      // or are assigned to the logged in user


      var allowedRoles = user.get('roles').split(','),
          loadedRoles = that.value().split(',');
      return _.filter(roleNames, function (role) {
        return _.contains(allowedRoles, role) || _.contains(loadedRoles, role);
      });
    })["catch"](function () {
      return [];
    });
  };

  RolesEditor.prototype.$getRolesContainerElement = function () {
    return this.jq().children('.rolesContainer');
  };
  /**
   * Add "RolesEditor" class.
   *
   * @param {JQuery} dom
   */


  RolesEditor.prototype.doInitialize = function (dom) {
    dom.addClass('RolesEditor');
    dom.append('<div class="rolesContainer"/>');
  };
  /**
   * The builder for a `RolesEditor` will create a boolean editor for each
   * available role.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */


  RolesEditor.prototype.makeBuilder = function () {
    var that = this,
        builder = new CompositeBuilder();

    builder.getKeys = function () {
      return that.$getAvailableRoles().then(function (roleNames) {
        var loadedRoles = that.value();

        if (that.getFormFactor() === Widget.formfactor.mini && typeof loadedRoles === 'string') {
          loadedRoles = loadedRoles.split(',');

          for (var i = roleNames.length - 1; i >= 0; i--) {
            if (roleNames.length > MAX_ROLES && !_.contains(loadedRoles, roleNames[i])) {
              roleNames.splice(i, 1);
            }
          }
        }

        return roleNames;
      });
    };

    builder.getValueFor = function (key) {
      return _.contains(this.getDataSource().split(','), key);
    };

    builder.getConfigFor = function (key) {
      return {
        properties: {
          trueText: key,
          falseText: key
        },
        formFactor: 'mini'
      };
    };

    builder.getDomFor = function () {
      return $('<div/>').appendTo(that.$getRolesContainerElement());
    };

    return builder;
  };
  /**
   * Read what roles are selected and join them together into a string.
   *
   * @returns {Promise} promise to be resolved with a comma-separated
   * string containing what roles are selected
   */


  RolesEditor.prototype.doRead = function () {
    var builder = this.getBuilder();
    return Promise.all([builder.getKeys(), builder.readAll()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          roleNames = _ref4[0],
          checks = _ref4[1];

      return _.filter(roleNames, function (roleName, i) {
        return checks[i];
      }).join(',');
    });
  };
  /**
   * Remove "RolesEditor" class.
   *
   * @returns {Promise}
   */


  RolesEditor.prototype.doDestroy = function () {
    this.jq().removeClass('RolesEditor');
    return CompositeEditor.prototype.doDestroy.apply(this, arguments);
  };

  return RolesEditor;
});
