function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/* jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/PageSizeEditor
 */
define(['baja!', 'baja!gx:Size', 'lex!pdf', 'log!nmodule.webEditors.wb.util.PageSizeEditor', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/util/pageSizeUtils', 'bajaux/events', 'bajaux/Widget', 'Promise', 'underscore'], function (baja, types, lexes, log, BaseEditor, OrderedMapEditor, fe, pageSizeUtils, events, Widget, Promise, _) {
  'use strict';

  var _lexes = _slicedToArray(lexes, 1),
      lex = _lexes[0];

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var logSevere = log.severe.bind(log);
  var portrait = 'pageSize.orient.portrait';
  var landscape = 'pageSize.orient.landscape';
  var pageSizeList = 'pageSize.list';
  var DEFAULT_PAGE_SIZE = baja.$('gx:Size', 8.5, 11);
  /**
   * Consists of two field editors, one for the official size of a page (such as Letter or Legal) and one for the
   * orientation (portrait or landscape).
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/wb/util/PageSizeEditor
   */

  var PageSizeEditor = /*#__PURE__*/function (_BaseEditor) {
    _inherits(PageSizeEditor, _BaseEditor);

    var _super = _createSuper(PageSizeEditor);

    function PageSizeEditor(params) {
      var _this;

      _classCallCheck(this, PageSizeEditor);

      _this = _super.call(this, _.extend({
        keyName: 'PageSizeEditor',
        moduleName: 'webEditors'
      }, {}, params)); // Height and Width < 2 inches produces an empty pdf

      _this.validators().add(function (size) {
        return _this.$getSupportedDimension().then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              supportedDim = _ref2[0],
              withUnits = _ref2[1];

          if (size.getWidth() <= supportedDim || size.getHeight() <= supportedDim) {
            throw new Error(lex.get({
              key: 'pageSize.custom.invalid',
              args: [withUnits]
            }));
          }
        });
      });

      return _this;
    }
    /**
     * Returns all the page sizes in map form. The resultant data structure maps the display name (lexicon key)
     * to the display key (repeated for convenience), display name (lexicon value), width and height.
     *
     * @private
     * @returns {baja.OrderedMap}
     */


    _createClass(PageSizeEditor, [{
      key: "$getSizeMap",
      value: function $getSizeMap() {
        var sizes = lex.get(pageSizeList).split(';');
        sizes.push('custom');
        var sizeMap = new baja.OrderedMap();
        sizes.forEach(function (sizeText) {
          var displayNameKey = 'pageSize.' + sizeText + '.displayName';
          var displayName = lex.get(displayNameKey);
          var width = parseFloat(lex.get('pageSize.' + sizeText + '.width'));
          var height = parseFloat(lex.get('pageSize.' + sizeText + '.height'));
          sizeMap.put(displayNameKey, {
            displayKey: displayNameKey,
            displayName: displayName,
            width: width,
            height: height
          });
        });
        return sizeMap;
      }
      /**
       * Returns the display symbol of unit based on the user's unit conversion.
       *
       * @private
       * @returns {string}
       */

    }, {
      key: "$getUserUnitDisplay",
      value: function $getUserUnitDisplay() {
        var _this2 = this;

        return baja.UnitDatabase.get().then(function (database) {
          return escape(database.convertUnit(_this2.$getUnitConversion(), database.getUnit('inch')).getSymbol());
        });
      }
      /**
       * Returns all the orientations in map form. The returned data structure is keyed by the lexicon key
       * of the orientation and maps to .text (lexicon value) and the lexicon key repeated for convenience.
       *
       * @private
       * @returns {baja.OrderedMap}
       */

    }, {
      key: "$getOrientationMap",
      value: function $getOrientationMap() {
        var orientationMap = new baja.OrderedMap();
        orientationMap.put(portrait, {
          displayKey: portrait,
          text: lex.get(portrait)
        });
        orientationMap.put(landscape, {
          displayKey: landscape,
          text: lex.get(landscape)
        });
        return orientationMap;
      }
      /**
       * Promise to build the size editor.
       *
       * @private
       * @param {JQuery} dom
       * @param {baja.OrderedMap} sizeMap
       * @returns {Promise}
       */

    }, {
      key: "$buildSizeSelector",
      value: function $buildSizeSelector(dom, sizeMap) {
        return fe.buildFor({
          formFactor: 'mini',
          properties: {
            lexicon: 'pdf'
          },
          type: OrderedMapEditor,
          dom: dom.find('.page-size-select'),
          value: sizeMap
        });
      }
      /**
       * Promise to build the orientation editor.
       *
       * @private
       * @param {JQuery} dom
       * @param {baja.OrderedMap} orientationMap
       * @returns {*}
       */

    }, {
      key: "$buildOrientationSelector",
      value: function $buildOrientationSelector(dom, orientationMap) {
        return fe.buildFor({
          formFactor: 'mini',
          properties: {
            lexicon: 'pdf'
          },
          type: OrderedMapEditor,
          dom: dom.find('.page-orientation-select'),
          value: orientationMap
        });
      }
      /**
       * Makes everything "look right" after the user selects an option from the
       * drop downs. If the user selects a standard size takes that gx:Size as a
       * parameter, otherwise if the user selects custom take in a "CUSTOM" string.
       *
       * @private
       * @param {module:nmodule/gx/rc/baja/Size|String} size
       * @returns {Promise}
       */

    }, {
      key: "$render",
      value: function $render(size) {
        var _this3 = this;

        var userSelectedCustom = size === 'CUSTOM';
        var sizeAndOrientation = !userSelectedCustom && pageSizeUtils.getSizeAndOrientation(size);
        this.jq().find('.custom-size-editor').toggle(!sizeAndOrientation);
        this.jq().find('.page-size-display').toggle(!!sizeAndOrientation);
        this.jq().find('.page-orientation-select').toggle(!!sizeAndOrientation);

        if (!userSelectedCustom) {
          if (sizeAndOrientation) {
            this.$getSizeEditor().setSelectedKey(sizeAndOrientation.sizeKey, true);
            this.$getOrientationEditor().setSelectedKey(sizeAndOrientation.orientation, true);
          }

          return Promise.all([this.$updateWidthAndHeightDisplay(size).then(function (formattedSize) {
            return _this3.$getCustomSizeEditor().load(formattedSize);
          })]);
        }

        return Promise.resolve();
      }
      /**
       * Returns the size editor.
       *
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
       */

    }, {
      key: "$getSizeEditor",
      value: function $getSizeEditor() {
        return Widget["in"](this.jq().find('.page-size-select'));
      }
      /**
       * Returns the custom size editor.
       *
       * @private
       * @returns {module:nmodule/gx/rc/fe/SizeEditor}
       */

    }, {
      key: "$getCustomSizeEditor",
      value: function $getCustomSizeEditor() {
        return Widget["in"](this.jq().find('.custom-size-editor'));
      }
      /**
       *
       * @private
       */

    }, {
      key: "$getUnitSelector",
      value: function $getUnitSelector() {
        return Widget["in"](this.jq().find('.unit-converter'));
      }
      /**
       * Returns the orientation editor.
       *
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
       */

    }, {
      key: "$getOrientationEditor",
      value: function $getOrientationEditor() {
        return Widget["in"](this.jq().find('.page-orientation-select'));
      }
      /**
       * Determines the standard size as selected by the user or a string 'CUSTOM'
       * indicating the user has selected the custom size option.
       *
       * @private
       * @returns {Promise.<module:nmodule/gx/rc/baja/Size|String>}
       */

    }, {
      key: "$readStandardSize",
      value: function $readStandardSize() {
        return Promise.all([this.$getSizeEditor().read(), this.$getOrientationEditor().read()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
              size = _ref4[0],
              orientation = _ref4[1];

          if (size.displayKey === 'pageSize.custom.displayName') {
            return 'CUSTOM';
          }

          return pageSizeUtils.makeFromSizeAndOrientation(size.displayName, orientation.text);
        });
      }
      /**
       * Returns the given size in inches or centimeters based on the system of measurement
       * the user has selected.
       *
       * @private
       * @param {module:nmodule/gx/rc/baja/Size} size
       * @returns {Promise.<module:nmodule/gx/rc/baja/Size>}
       */

    }, {
      key: "$toDisplaySize",
      value: function $toDisplaySize(size) {
        return Promise.all([baja.Unit.convert(size.getWidth(), {
          fromUnits: 'inch',
          unitConversion: this.$getUnitConversion(),
          precision: 2
        }), baja.Unit.convert(size.getHeight(), {
          fromUnits: 'inch',
          unitConversion: this.$getUnitConversion(),
          precision: 2
        })]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
              width = _ref6[0],
              height = _ref6[1];

          return baja.$('gx:Size', width, height);
        });
      }
      /**
       * Returns the given size in inches
       *
       * @private
       * @param {module:nmodule/gx/rc/baja/Size} size
       * @returns {Promise.<module:nmodule/gx/rc/baja/Size>}
       */

    }, {
      key: "$fromDisplaySize",
      value: function $fromDisplaySize(size) {
        return Promise.all([baja.Unit.convert(size.getWidth(), {
          unitConversion: this.$getUnitConversion(),
          toUnits: 'inch'
        }), baja.Unit.convert(size.getHeight(), {
          unitConversion: this.$getUnitConversion(),
          toUnits: 'inch'
        })]).then(function (_ref7) {
          var _ref8 = _slicedToArray(_ref7, 2),
              width = _ref8[0],
              height = _ref8[1];

          return baja.$('gx:Size', width, height);
        });
      }
      /**
       * Update the size text display with the loaded size formatted and converted
       * to the user's system of measurement.
       *
       * @private
       * @param {module:nmodule/gx/rc/baja/Size} size
       * @returns {Promise}
       */

    }, {
      key: "$updateWidthAndHeightDisplay",
      value: function $updateWidthAndHeightDisplay(size) {
        var _this4 = this;

        return this.$toDisplaySize(size).then(function (convertedSize) {
          _this4.jq().find('.page-width').html(convertedSize.getWidth().toString());

          _this4.jq().find('.page-height').html(convertedSize.getHeight().toString());

          return convertedSize;
        });
      }
      /**
       * Page size greater than or equal to 2 inches only
       * is supported.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$getSupportedDimension",
      value: function $getSupportedDimension() {
        var _this5 = this;

        return baja.UnitDatabase.get().then(function (unitDb) {
          var SUPPORTED_INCHES = 2;
          var inUnit = unitDb.getUnit('inch');

          var unitConversion = _this5.$getUnitConversion();

          return Promise.all([SUPPORTED_INCHES, SUPPORTED_INCHES.toString({
            units: inUnit,
            unitConversion: unitConversion
          })]);
        });
      }
      /**
       * Returns the user configured Unit Conversion system.
       *
       * @private
       * @returns {*}
       */

    }, {
      key: "$getUnitConversion",
      value: function $getUnitConversion() {
        return this.properties().getValue('unitConversion');
      }
      /**
       * Creates an editor with dropdown fields for page size and page orientation.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */

    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this6 = this;

        var sizeMap = this.$getSizeMap();
        var orientationMap = this.$getOrientationMap();
        dom.on(MODIFY_EVENT, 'span', function (event, editor) {
          _this6.setModified(true);

          return false;
        });
        dom.on(MODIFY_EVENT, '.page-size-select', function (event, editor) {
          _this6.$readStandardSize().then(function (size) {
            return _this6.$render(size);
          })["catch"](logSevere);

          return false;
        });
        dom.on(MODIFY_EVENT, '.page-orientation-select', function () {
          _this6.$readStandardSize().then(function (size) {
            return _this6.$render(size);
          })["catch"](logSevere);

          return false;
        });
        return this.$getUserUnitDisplay().then(function (unitSymbol) {
          var template = "\n            <span class=\"page-size-select\"></span>\n            <span class=\"page-orientation-select\"></span>\n            <span class=\"page-size-display\">\n              <span class=\"page-width\"></span> x <span class=\"page-height\"></span>\n            </span>\n            <span class=\"custom-size-editor\"></span>\n            <span class=\"unit-indicator\">".concat(unitSymbol, "</span>\n          ");
          dom.html(template);
          return Promise.all([_this6.$buildSizeSelector(dom, sizeMap), _this6.$buildOrientationSelector(dom, orientationMap), fe.buildFor({
            formFactor: 'mini',
            dom: dom.find('.custom-size-editor'),
            value: DEFAULT_PAGE_SIZE
          })]);
        });
      }
      /**
       * Reads the values of the size and orientation editors and returns them together in a PageSize object.
       *
       * @returns {Promise.<module:nmodule/gx/rc/baja/Size>}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        var _this7 = this;

        return this.$getCustomSizeEditor().read().then(function (readValue) {
          return _this7.$fromDisplaySize(readValue);
        });
      }
      /**
       * Loads the width field of the size parameter into the width editor, and the height field of the size parameter into
       * the height editor.
       *
       * @param {module:nmodule/gx/rc/baja/Size} size
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(size) {
        var _this8 = this;

        var sizeAndOrientation = pageSizeUtils.getSizeAndOrientation(size);

        if (sizeAndOrientation) {
          this.$getSizeEditor().setSelectedKey(sizeAndOrientation.sizeKey);
          this.$getOrientationEditor().setSelectedKey(sizeAndOrientation.orientation);
        }

        return Promise.all([this.$updateWidthAndHeightDisplay(size).then(function (convertedSize) {
          return _this8.$getCustomSizeEditor().load(convertedSize);
        })]);
      }
      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }
      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */

    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }
      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */

    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }
    }]);

    return PageSizeEditor;
  }(BaseEditor);

  return PageSizeEditor;
});
