function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/CertificateAliasEditor
 */
define(['baja!', 'nmodule/webEditors/rc/fe/baja/AdapterEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils'], function (baja, AdapterEditor, spaceUtils, subscriberUtils) {
  'use strict';

  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var getCertManagerService = leaseWhenNeeded(function (base) {
    return resolveService('platCrypto:CertManagerService', base);
  });
  /**
   * Editor for choosing a certificate alias. It will retrieve the list of
   * certificate alias names using
   * `platCrypto:CertManagerService.getCertificateAliases`. It supports the
   * following bajaux Properties:
   *
   * - `storeId`: (string, default `'USER_KEY_STORE'`) selects which crypto
   *   store to query from. Should be a member of
   *   `com.tridium.crypto.core.io.CryptoStoreId`.
   * - `purposeId`: (string, default `'SERVER_CERT'`) selects which key purpose to filter
   *   the certificate alias names on. Use an empty string to show all aliases.
   *   Should be a member of `com.tridium.crypto.core.cert.KeyPurpose`.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/CertificateAliasEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/AdapterEditor
   */

  return /*#__PURE__*/function (_AdapterEditor) {
    _inherits(CertificateAliasEditor, _AdapterEditor);

    var _super = _createSuper(CertificateAliasEditor);

    function CertificateAliasEditor() {
      _classCallCheck(this, CertificateAliasEditor);

      return _super.apply(this, arguments);
    }

    _createClass(CertificateAliasEditor, [{
      key: "toConfig",

      /**
       * Build as a StringEditor, with the list of certificate aliases retrieved
       * from the station as the datalist.
       * @param {string} certificateName
       * @returns {Promise.<object>}
       */
      value: function toConfig(certificateName) {
        return this.$resolveCertificateAliasNames()["catch"](function () {
          return [];
        }).then(function (certNames) {
          return {
            value: certificateName,
            properties: {
              datalist: certNames.join(';'),
              'relevant-filter': false
            },
            formFactor: 'mini'
          };
        });
      }
      /**
       * @private
       * @returns {Promise.<string[]>}
       */

    }, {
      key: "$resolveCertificateAliasNames",
      value: function $resolveCertificateAliasNames() {
        var props = this.properties();
        var storeId = props.getValue('storeId');
        var purposeId = props.getValue('purposeId');

        if (typeof storeId !== 'string') {
          storeId = 'USER_KEY_STORE';
        }

        if (typeof purposeId !== 'string') {
          purposeId = 'SERVER_CERT';
        }

        return this.$resolveCertManagerService().then(function (service) {
          return service.rpc('getCertificateAliases', storeId, purposeId);
        });
      }
      /**
       * @private
       * @returns {Promise.<baja.Component>}
       */

    }, {
      key: "$resolveCertManagerService",
      value: function $resolveCertManagerService() {
        return this.getOrdBase().then(getCertManagerService);
      }
    }]);

    return CertificateAliasEditor;
  }(AdapterEditor);
});
