function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Patrick Sager
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/AutoLogoffSettingsEditor
 */
define(['baja!', 'baja!baja:AutoLogoffSettings', 'lex!webEditors', 'underscore', 'Promise', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'hbs!nmodule/webEditors/rc/wb/util/template/AutoLogoffSettingsEditor'], function (baja, types, lexs, _, Promise, events, ComplexCompositeEditor, template) {
  'use strict';

  var KEY_AUTO_LOGOFF_ENABLED = 'autoLogoffEnabled',
      KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD = 'useDefaultAutoLogoffPeriod',
      KEY_AUTO_LOGOFF_PERIOD = 'autoLogoffPeriod',
      keys = [KEY_AUTO_LOGOFF_ENABLED, KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD, KEY_AUTO_LOGOFF_PERIOD],
      lex = lexs[0];
  /**
   * Editor for setting the auto logoff settings on a user.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/AutoLogoffSettingsEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */

  var AutoLogoffSettingsEditor = function AutoLogoffSettingsEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };

  AutoLogoffSettingsEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  AutoLogoffSettingsEditor.prototype.constructor = AutoLogoffSettingsEditor;
  /**
   * Return the AutoLogoffSettings properties.
   *
   * @returns {string[]}
   */

  AutoLogoffSettingsEditor.prototype.getSlotFilter = function () {
    return keys;
  };
  /**
   * Set up the dom and event handler
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */


  AutoLogoffSettingsEditor.prototype.doInitialize = function (dom) {
    var that = this;

    var rows = _.map(keys, function (key) {
      return {
        key: key,
        name: lex.get('AutoLogoffSettingsEditor.' + key)
      };
    });

    dom.html(template({
      rows: rows
    }));
    dom.on(events.MODIFY_EVENT, function () {
      that.doReadonly(that.isReadonly())["catch"](function () {//if we can't set the editors readonly, just leave them as they are.
      });
      return true;
    });
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  /**
   * Make the ComplexCompositeBuilder.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/ComplexCompositeBuilder}
   */


  AutoLogoffSettingsEditor.prototype.makeBuilder = function () {
    var builder = ComplexCompositeEditor.prototype.makeBuilder.apply(this, arguments),
        that = this;

    builder.getDomFor = function (key) {
      return that.jq().find('.key-' + key);
    };

    return builder;
  };
  /**
   * Load the AutoLogoffSettings into the editor and load the child editors.
   *
   * @param {baja.Complex} value a `baja:AutoLogoffSettings` instance
   * @returns {Promise}
   */


  AutoLogoffSettingsEditor.prototype.doLoad = function (value) {
    var that = this;

    if (!baja.hasType(value, 'baja:AutoLogoffSettings')) {
      return Promise.reject(new Error('baja:AutoLogoffSettings required'));
    }

    return ComplexCompositeEditor.prototype.doLoad.apply(this, arguments).then(function () {
      var builder = that.getBuilder();

      if (!value.get(KEY_AUTO_LOGOFF_ENABLED)) {
        return Promise.all([builder.getEditorFor(KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD).setReadonly(true), builder.getEditorFor(KEY_AUTO_LOGOFF_PERIOD).setReadonly(true)]);
      } else if (value.get(KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD)) {
        return builder.getEditorFor(KEY_AUTO_LOGOFF_PERIOD).setReadonly(true);
      }
    });
  };
  /**
   * Set child editors readonly/writable based on the readonly param and
   * the values of the AutoLogoffEnabled and UseDefaultAutoLogoffPeriod editors
   *
   * @param {boolean} readonly
   * @returns {Promise}
   */


  AutoLogoffSettingsEditor.prototype.doReadonly = function (readonly) {
    var builder = this.getBuilder(),
        enabledEditor = builder.getEditorFor(KEY_AUTO_LOGOFF_ENABLED),
        useDefaultEditor = builder.getEditorFor(KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD),
        autoLogoffPeriodEditor = builder.getEditorFor(KEY_AUTO_LOGOFF_PERIOD);

    if (!enabledEditor || !useDefaultEditor || !autoLogoffPeriodEditor) {
      return Promise.resolve();
    }

    return Promise.all([enabledEditor.read(), useDefaultEditor.read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          enabledValue = _ref2[0],
          useDefaultValue = _ref2[1];

      return Promise.all([enabledEditor.setReadonly(readonly), useDefaultEditor.setReadonly(readonly || !enabledValue), autoLogoffPeriodEditor.setReadonly(readonly || !enabledValue || useDefaultValue)]);
    });
  };

  return AutoLogoffSettingsEditor;
});
