function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/tree/BajaNavTreeNode
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.tree.BajaNavTreeNode', 'Promise', 'underscore', 'nmodule/js/rc/tinyevents/tinyevents', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/webEditors/rc/util/OrderedEventProcessor'], function (baja, log, Promise, _, TinyEvents, compUtils, typeUtils, TreeNode, OrderedEventProcessor) {
  'use strict';

  var bulkAdd = compUtils.bulkAdd,
      isComponent = typeUtils.isComponent,
      logError = log.severe.bind(log);

  var getNavEventManager = function () {
    var navEventManager;
    return function () {
      if (!navEventManager) {
        navEventManager = new TinyEvents();
        baja.nav.attach('added', function (navOrd, newNode) {
          navEventManager.emit('added', newNode, navOrd);
        });
        baja.nav.attach('removed', function (navOrd, name) {
          navEventManager.emit('removed', name, navOrd);
        });
        baja.nav.attach('renamed', function (navOrd, newNode, oldName) {
          navEventManager.emit('renamed', newNode, oldName, navOrd);
        });
        baja.nav.attach('reordered', function (navOrd) {
          navEventManager.emit('reordered', navOrd);
        });
      }

      return navEventManager;
    };
  }();

  function getNavName(navNode) {
    return navNode.getNavName();
  }

  function hasNavName(navKids, name) {
    for (var i = 0; i < navKids.length; i++) {
      if (navKids[i].getNavName() === name) {
        return true;
      }
    }
  }
  /**
   * A tree node backed by a Baja nav node.
   *
   * The name, display, and icon values will be picked up directly from the
   * nav node's corresponding properties. Child tree nodes will be built on
   * demand by calling `getNavChildren()` on the nav node.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/tree/BajaNavTreeNode
   * @param {baja.Value} navNode a nav node (any value implementing
   * `baja:INavNode`)
   * @throws {Error} if the given node is not an instance of `baja:INavNode`
   */


  var BajaNavTreeNode = function BajaNavTreeNode(navNode) {
    if (!baja.hasType(navNode, 'baja:INavNode')) {
      throw new Error('instance of baja:INavNode required');
    }

    var that = this,
        name = navNode.getNavName(),
        display = navNode.getNavDisplayName();
    that.$navNode = navNode;
    that.$processor = new OrderedEventProcessor();
    TreeNode.call(this, name, display);
  };

  BajaNavTreeNode.prototype = Object.create(TreeNode.prototype);
  BajaNavTreeNode.prototype.constructor = BajaNavTreeNode;
  /**
   * Resolve the nav display name of the loaded node.
   *
   * @returns {Promise}
   */

  BajaNavTreeNode.prototype.toDisplay = function () {
    return Promise.resolve(this.value().getNavDisplayName());
  };
  /**
   * Returns the Baja nav node used to construct this TreeNode.
   * @returns {baja.Value} nav node (e.g. a Component)
   */


  BajaNavTreeNode.prototype.value = function () {
    return this.$navNode;
  };
  /**
   * Returns array of image URIs from the backing nav node's NavIcon.
   * @returns {Array.<String>} array of image URIs
   */


  BajaNavTreeNode.prototype.getIcon = function () {
    return this.value().getNavIcon().getImageUris();
  };
  /**
   * Loads the array of child nodes by building them up from the nav node's
   * NavChildren.
   * @returns {Promise} promise to be resolved with an array of
   * `BajaNavTreeNode`s created from the nav node's NavChildren
   */


  BajaNavTreeNode.prototype.$loadKids = function (params) {
    var that = this,
        navNode = that.value(),
        inpBatch = params && params.batch,
        batchToUse = inpBatch || new baja.comm.Batch(),
        progressCallback = params && params.progressCallback || _.noop,
        prom = Promise.all([navNode.getNavChildren({
      batch: batchToUse
    }), //must load slots so displayNames slot is available if present.
    //otherwise getNavDisplayName on kids does not work.
    isComponent(navNode) && navNode.loadSlots({
      batch: batchToUse
    })]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          navKids = _ref2[0];

      return _.map(navKids, function (navKid) {
        return new BajaNavTreeNode(navKid);
      });
    });
    progressCallback('commitReady');

    if (!inpBatch) {
      batchToUse.commit();
    } //TODO: diff from WB: i get PlatformServices/TcpIpService/Settings, WB doesn't


    return prom;
  };
  /**
   * Returns true if the given value has a NavOrd that is equivalent to this
   * node's backing nav node's NavOrd.
   * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode|baja.Ord|baja.Value} obj
   * a tree node, nav node, or ORD to compare
   * @returns {Boolean}
   */


  BajaNavTreeNode.prototype.equals = function (obj) {
    if (!obj) {
      return false;
    }

    var navNode = obj instanceof TreeNode ? obj.value() : obj,
        navOrd;

    if (navNode instanceof baja.Ord) {
      navOrd = navNode;
    } else if (navNode && navNode.getNavOrd) {
      navOrd = navNode.getNavOrd();
    }

    if (!navOrd) {
      if (navNode.getHandle) {
        return this.value().getHandle() === navNode.getHandle();
      }

      return false;
    }

    return this.value().getNavOrd().equivalent(navOrd);
  };
  /**
   * True - can drag a NavNode onto something else.
   *
   * @returns {boolean}
   */


  BajaNavTreeNode.prototype.isDraggable = function () {
    return true;
  };
  /**
   * Callback for an added nav event.
   *
   * @private
   * @inner
   *
   * @param newNode The new Nav Node.
   * @param {baja.Ord} navOrd The nav ORD.
   * @return {Promise} Optionally returns a promise if the callback is asynchronous.
   */


  var addedHandler = function addedHandler(newNode, navOrd) {
    var that = this,
        navNode = that.value();

    if (that.$kidsLoaded && navNode && navNode.getNavOrd() && navNode.getNavOrd().equals(navOrd)) {
      /* TODO: BajaScript fires duplicate added events when resolving an ORD
       * or retrieving nav children, so make sure this isn't a duplicate.
       * c.f. NCCB-7550
       * also it doesn't respect getNavChildren() when components are
       * resolved, so you get nav events for components which are not
       * nav children. */
      //TODO: throttle this
      return Promise.all([that.$navNode.getNavChildren(), that.getKid(newNode.getNavName())]).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
            navKids = _ref4[0],
            existingKid = _ref4[1];

        //if the Baja node is not an actual nav child or it already
        //exists in the tree node, don't add the kid node.
        if (hasNavName(navKids, newNode.getNavName()) && !existingKid) {
          return that.add(new BajaNavTreeNode(newNode));
        }
      })["catch"](logError);
    }
  };
  /**
   * Callback for a removed nav event.
   *
   * @private
   * @inner
   *
   * @param  {String} name The name of the removed node.
   * @param  {baja.Ord} navOrd The nav ORD.
   * @return {Promise} Optionally returns a promise if the callback is asynchronous.
   */


  var removedHandler = function removedHandler(name, navOrd) {
    var that = this,
        navNode = that.value();

    if (that.$kidsLoaded && navNode && navNode.getNavOrd() && navNode.getNavOrd().equals(navOrd)) {
      return that.remove(name)["catch"](logError);
    }
  };
  /**
   * Callback for a renamed nav event.
   *
   * @private
   * @inner
   *
   * @param  newNode The new Nav Node.
   * @param  {String} oldName The old name of the Nav Node.
   * @param  {baja.Ord} navOrd The nav ORD.
   * @return {Promise} Optionally returns a promise if the callback is asynchronous.
   */


  var renamedHandler = function renamedHandler(newNode, oldName, navOrd) {
    var that = this,
        navNode = that.value();

    if (that.$kidsLoaded && navNode && navNode.getNavOrd() && navNode.getNavOrd().equals(navOrd)) {
      return that.rename(oldName, newNode.getNavName())["catch"](logError);
    }
  };
  /**
   * Callback for a reordered nav event.
   *
   * @private
   * @inner
   *
   * @param  {baja.Ord} navOrd The nav ORD.
   * @return {Promise} Optionally returns a promise if the callback is asynchronous.
   */


  var reorderedHandler = function reorderedHandler(navOrd) {
    var that = this,
        navNode = that.value();

    if (that.$kidsLoaded && navNode && navNode.getNavOrd() && navNode.getNavOrd().equals(navOrd)) {
      return navNode.getNavChildren().then(function (navKids) {
        var names = _.map(navKids, getNavName);

        return that.reorder(names);
      })["catch"](logError);
    }
  };
  /**
   * Registers the node for nav events from BajaScript. It will
   * add/remove/rename/etc. its own nodes in direct response to these nav
   * events. Make sure that when you are finished with an activated node,
   * you properly call its `destroy()` method to ensure that these event
   * handlers are properly cleaned up.
   */


  BajaNavTreeNode.prototype.doActivate = function () {
    var that = this,
        processor = that.$processor;
    that.$addedHandler = processor.wrap(_.bind(addedHandler, that));
    that.$removedHandler = processor.wrap(_.bind(removedHandler, that));
    that.$renamedHandler = processor.wrap(_.bind(renamedHandler, that));
    that.$reorderedHandler = processor.wrap(_.bind(reorderedHandler, that));
    getNavEventManager().on('added', that.$addedHandler).on('removed', that.$removedHandler).on('renamed', that.$renamedHandler).on('reordered', that.$reorderedHandler);
  };
  /**
   * Removes all nav event listeners subscribed by `doActivate`.
   */


  BajaNavTreeNode.prototype.doDestroy = function () {
    var that = this;
    getNavEventManager().removeListener('added', that.$addedHandler).removeListener('removed', that.$removedHandler).removeListener('renamed', that.$renamedHandler).removeListener('reordered', that.$reorderedHandler);
    that.$processor.clear();
  };
  /**
   * Resolves the loaded value's nav ORD converted to URI.
   * @returns {Promise}
   */


  BajaNavTreeNode.prototype.toHyperlinkUri = function () {
    var navNode = this.value(),
        navOrd = navNode && navNode.getNavOrd(),
        uri = navOrd && navOrd.toUri();
    return Promise.resolve(uri);
  };
  /**
   * Can drop onto a nav tree node if the target is a Component and I have
   * admin write permissions on it.
   *
   * @returns {boolean}
   */


  BajaNavTreeNode.prototype.isDropTarget = function () {
    var navNode = this.value();
    return baja.hasType(navNode, 'baja:Component') && navNode.getPermissions().hasAdminWrite();
  };
  /**
   * Add instances of the nav nodes onto the Component backing this nav node.
   *
   * @param {Array.<baja.NavNode>} navNodes
   * @returns {Promise} promise to be resolved after bulk-adding instances onto
   * the component, or rejected if the drop could not be completed
   */


  BajaNavTreeNode.prototype.doDrop = function (navNodes) {
    var that = this,
        navNode = that.value();

    if (!that.isDropTarget()) {
      return Promise.reject(new Error('not a valid drop target'));
    }

    if (!navNodes || !navNodes.length) {
      return Promise.reject(new Error('no valid nav nodes found'));
    }

    return bulkAdd(navNode, navNodes);
  };

  return BajaNavTreeNode;
});
