/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
//TODO: specs

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/tree/BajaNavFileTreeNode
 */
define(['underscore', 'nmodule/webEditors/rc/wb/tree/BajaNavTreeNode'], function (_, BajaNavTreeNode) {
  'use strict';
  /**
   * TreeNode for loading in nav nodes from a Baja nav file.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/tree/BajaNavFileTreeNode
   * @extends module:nmodule/webEditors/rc/wb/tree/BajaNavTreeNode
   * @param {baja.NavContainer} navNode
   */

  var BajaNavFileTreeNode = function BajaNavFileTreeNode(navNode) {
    BajaNavTreeNode.apply(this, arguments);
  };

  BajaNavFileTreeNode.prototype = Object.create(BajaNavTreeNode.prototype);
  BajaNavFileTreeNode.prototype.constructor = BajaNavFileTreeNode;
  /**
   * Loads kid nodes. Note that this will never use a batch since BajaScript
   * downloads the whole nav file at once.
   *
   * @returns {Promise}
   */

  BajaNavFileTreeNode.prototype.$loadKids = function () {
    return this.value().getNavChildren().then(function (kids) {
      return _.map(kids, function (kid) {
        return new BajaNavFileTreeNode(kid);
      });
    });
  };
  /**
   * Nav file nodes don't support drag and drop.
   *
   * @returns {boolean} false
   */


  BajaNavFileTreeNode.prototype.isDraggable = function () {
    return false;
  };
  /**
   * Nav file nodes don't support drag and drop.
   *
   * @returns {boolean} false
   */


  BajaNavFileTreeNode.prototype.isDropTarget = function () {
    return false;
  };
  /**
   * A nav file node is only equal to itself. Since a nav file node and a
   * station nav node can share the same nav ORD, we might confuse the two
   * otherwise.
   *
   * @param node
   * @returns {boolean}
   */


  BajaNavFileTreeNode.prototype.equals = function (node) {
    return node === this;
  };

  return BajaNavFileTreeNode;
});
