/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * @module nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn
 */
define(['nmodule/webEditors/rc/wb/table/model/Column'], function (Column) {
  'use strict';
  /**
   * API Status: **Development**
   *
   * Column for showing the value of a JavaScript Object's property
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/Column
   * @param {String} [name] column name and name of the property retrieved from the
   *    JavaScript object.
   * @param {Object} [params]
   * @param {String} [params.displayName] column display name; `name` will be
   * used if omitted.
   */

  var JsonObjectPropertyColumn = function JsonObjectPropertyColumn(name, params) {
    Column.apply(this, arguments);
  };

  JsonObjectPropertyColumn.prototype = Object.create(Column.prototype);
  JsonObjectPropertyColumn.prototype.constructor = JsonObjectPropertyColumn;
  /**
   * Get the value of the JSON element specified in the constructor from
   * the row's loaded component.
   *
   * @example
   *
   * // Set up the model with a 'text' column.
   *
   * let columns = [new JsonObjectPropertyColumn('text')];
   * let model = new TableModel({columns: columns});
   * model.insertRows([new Row({ text: 'This is a test.' })]);
   *
   * // Use the model
   * expect(column.getValueFor(row)).toBe('This is a test.');
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {*}
   */

  JsonObjectPropertyColumn.prototype.getValueFor = function (row) {
    return row.getSubject()[this.getName()];
  };

  return JsonObjectPropertyColumn;
});
