function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
 */
define(['bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'Promise', 'underscore', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu', 'nmodule/webEditors/rc/wb/menu/Separator'], function (Command, CommandGroup, Promise, _, ExportCommand, CommandGroupContextMenu, Separator) {
  'use strict';

  var BLANK_ICON = 'module://icons/x16/blank.png',
      CHECK_ICON = 'module://icons/x16/whiteIcons/check.png';
  /**
   * Default context menu for a Table. Will include an export command and
   * commands to show/hide individual columns.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
   * @extends module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   */

  var DefaultTableContextMenu = function DefaultTableContextMenu(table) {
    CommandGroupContextMenu.apply(this, arguments);
    this.$table = table;
  };

  DefaultTableContextMenu.prototype = Object.create(CommandGroupContextMenu.prototype);
  DefaultTableContextMenu.prototype.constructor = DefaultTableContextMenu;
  /**
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */

  DefaultTableContextMenu.prototype.toContextMenu = function () {
    var table = this.$table;
    return Promise.all([getExportCommand(table), new Separator(), getShowHideCommands(table)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
          exportCmd = _ref2[0],
          separator = _ref2[1],
          showHideCommands = _ref2[2];

      return new CommandGroup({
        commands: [exportCmd, separator].concat(showHideCommands)
      });
    });
  };
  /**
   * @param {JQuery} jq
   * @param {string} selector
   */


  DefaultTableContextMenu.prototype.arm = function (jq, selector) {
    var that = this;
    jq.on('click', selector, function (e) {
      return that.$doContextMenu(e);
    });
    that.$armContextMenuAsync(jq, selector);
  };
  /**
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   * @returns {module:bajaux/commands/Command}
   */


  function getExportCommand(table) {
    return new ExportCommand(table);
  }

  var ShowHideColumnCommand = function ShowHideColumnCommand(column, displayName) {
    Command.call(this, {
      displayName: displayName,
      icon: getIcon(column),
      func: function func() {
        column.setUnseen(!column.isUnseen());
        this.setIcon(getIcon(column));
      }
    });
  };

  ShowHideColumnCommand.prototype = Object.create(Command.prototype);
  ShowHideColumnCommand.prototype.constructor = ShowHideColumnCommand;

  ShowHideColumnCommand.prototype.hideAfterInvoke = function () {
    return false;
  };

  ShowHideColumnCommand.prototype.safeToHideIcon = function () {
    return false;
  };
  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Column} column
   * @returns {string}
   */


  function getIcon(column) {
    return column.isUnseen() ? BLANK_ICON : CHECK_ICON;
  }
  /**
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   * @returns {Promise<module:bajaux/commands/Command>}
   */


  function getShowHideCommands(table) {
    var model = table.getModel(),
        columns = _.filter(model.getColumns(), function (col) {
      return col.isHidable();
    });

    return Promise.all(columns.map(function (column) {
      return Promise.resolve(column.toDisplayName()).then(function (displayName) {
        return new ShowHideColumnCommand(column, displayName);
      });
    }));
  }

  return DefaultTableContextMenu;
});
