function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/shell/TitlePane
 */
define(['Promise', 'bajaux/Widget', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'nmodule/webEditors/rc/fe/fe', 'hbs!nmodule/webEditors/rc/wb/shell/template/TitlePane'], function (Promise, Widget, CommandGroup, CommandButtonGroup, fe, tplTitlePane) {
  'use strict';
  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/shell/TitlePane
   * @extends module:bajaux/Widget
   */

  var TitlePane = function TitlePane() {
    Widget.apply(this, arguments);
  };

  TitlePane.prototype = Object.create(Widget.prototype);
  TitlePane.prototype.constructor = TitlePane;
  /**
   * @private
   * @returns {JQuery}
   */

  TitlePane.prototype.$getDisplayNameElement = function () {
    return this.jq().children('.header').find('.tab');
  };
  /**
   * @private
   * @returns {JQuery}
   */


  TitlePane.prototype.$getCommandsElement = function () {
    return this.jq().children('.header').find('.commands');
  };
  /**
   * @private
   * @returns {JQuery}
   */


  TitlePane.prototype.$getControlsElement = function () {
    return this.jq().children('.header').find('.controls');
  };
  /**
   * @private
   * @returns {module:bajaux/util/CommandButtonGroup}
   */


  TitlePane.prototype.$getCommandButtonGroup = function () {
    return Widget["in"](this.$getCommandsElement());
  };
  /**
   * @private
   * @returns {JQuery}
   */


  TitlePane.prototype.$getContentElement = function () {
    return this.jq().children('.content');
  };
  /**
   * @param {JQuery} dom
   */


  TitlePane.prototype.doInitialize = function (dom) {
    if (!dom.hasClass('TitlePane')) {
      dom.html(tplTitlePane({}));
      dom.addClass('TitlePane');
    }
  };
  /**
   * @param {*} value
   * @returns {Promise}
   */


  TitlePane.prototype.doLoad = function (value) {
    var widget = this.getContentWidget();

    if (!widget) {
      return Promise.reject(new Error('no content widget set'));
    }

    return widget.load(value);
  };
  /**
   * @returns {module:bajaux/Widget}
   */


  TitlePane.prototype.getContentWidget = function () {
    var contentElement = this.$getContentElement(); //TODO: because the shell profile loads an entire hx view into the content element, the actual widget gets instantiated a couple levels down.

    return Widget["in"](contentElement) || Widget["in"](contentElement.children('.bajaux-container').children('.bajaux-widget-container').children('.bajaux-widget'));
  };
  /**
   * @param {module:bajaux/Widget} widget
   * @returns {Promise}
   */


  TitlePane.prototype.setContentWidget = function (widget) {
    var that = this,
        oldWidget;

    if (!widget) {
      return Promise.reject(new Error('widget required'));
    }

    oldWidget = that.getContentWidget();
    return Promise.all([oldWidget && oldWidget !== widget && oldWidget.destroy(), that.$destroyCommandButtons()]).then(function () {
      return that.buildCommandGroup(widget);
    }).then(function (commandGroup) {
      return Promise.all([widget.toDisplayName(), !widget.jq() && widget.initialize(that.$getContentElement()), fe.buildFor({
        value: commandGroup,
        dom: that.$getCommandsElement(),
        type: CommandButtonGroup,
        properties: {
          toolbar: true
        }
      })]);
    }).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          displayName = _ref2[0];

      that.$getDisplayNameElement().text(displayName);
    });
  };
  /**
   * Override point to allow a TitlePane to configure exactly which commands are
   * shown in its header for a particular widget. The default behavior is just
   * show all the widget's commands.
   *
   * @param {module:bajaux/Widget} widget
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */


  TitlePane.prototype.buildCommandGroup = function (widget) {
    return Promise.resolve(new CommandGroup({
      commands: widget.getCommandGroup().getChildren()
    }));
  };
  /**
   * @returns {Promise}
   */


  TitlePane.prototype.doDestroy = function () {
    var that = this,
        content = that.getContentWidget();
    that.jq().removeClass('TitlePane');
    return Promise.resolve(content && content.destroy());
  };
  /**
   * @private
   * @returns {Promise}
   */


  TitlePane.prototype.$destroyCommandButtons = function () {
    var buttons = this.$getCommandButtonGroup();
    return Promise.resolve(buttons && buttons.destroy());
  };

  return TitlePane;
});
