function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson.
 */

/*jshint browser: true*/

/**
 * API Status: **Private**
 *
 * Loads the Search Sidebar.
 *
 * @module nmodule/webEditors/rc/wb/profile/searchSideBar
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.profile.searchSideBar', 'Promise', 'nmodule/webEditors/rc/fe/fe', "nmodule/webEditors/rc/wb/shell/TitlePane"], function (baja, log, Promise, fe, TitlePane) {
  'use strict';

  var logError = log.severe.bind(log);
  /**
   * Loads the Search Sidebar.
   *
   * @inner
   * @private
   *
   * @param  {JQuery} dom The jQuery DOM wrapper for the DOM to load the Sidebar into.
   */

  return function load(dom) {
    dom.one("sidebar-layout", function () {
      var titlePane = new TitlePane();
      return Promise.all([fe.makeFor({
        moduleName: 'search',
        keyName: 'SearchWidget',
        type: 'search:SearchWidget',
        formFactor: 'compact'
      }), baja.Ord.make('service:search:SearchService').get(), titlePane.initialize(dom)]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            searchWidget = _ref2[0],
            searchService = _ref2[1];

        return titlePane.setContentWidget(searchWidget).then(function () {
          return searchWidget.load(searchService);
        });
      })["catch"](logError);
    });
  };
});
