function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */
define(['baja!', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/transform/ExportCommand'], function (baja, $, Promise, _, asyncUtils, ExportCommand) {
  'use strict';
  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/wb/profile/profileUtils
   */

  var exports = {};
  var doRequire = asyncUtils.doRequire;
  /**
   * @returns {baja.Ord} the ORD currently being viewed in the profile. This ORD
   * will correspond to the current ORD in Workbench, even if used in the
   * browser (i.e. it may contain `fox:` or similar schemes). Call
   * `.relativizeToSession()` if needed.
   */

  exports.getCurrentOrd = function () {
    return exports.uriToOrd(location.href);
  };
  /**
   * If there is a view query, get the ord without it.
   * @param {baja.Ord} [ord] if the ord is not present, the `getCurrentOrd()` will be used.
   * @returns {baja.Ord} the ORD without the View Query
   */


  exports.getOrdWithoutViewQuery = function (ord) {
    var ordStr = getOrdStrFromParam(ord);
    var viewIndex = getViewIndex(ordStr);

    if (viewIndex > -1) {
      return baja.Ord.make(ordStr.substring(0, viewIndex - 1));
    }

    return baja.Ord.make(ordStr);
  };
  /**
   * @param {string|undefined} uri
   * @param {object} [params]
   * @param {string} [params.host] specify the desired host in the generated
   * ORD. If omitted, will be parsed out of the URI, or omitted if the URI is
   * relative.
   * @param {number} [params.port] specify the desired port in the generated
   * ORD.
   * @param {string} [params.protocol] specify the desired protocol in the
   * generated ORD. If omitted, will be `fox` for an `http` URI, `foxs` for an
   * `https` URI, or omitted if the URI is relative.
   * @returns {baja.Ord} an ORD parsed from the given URI. Will be
   * `baja.Ord.DEFAULT` if the URI did not match the expected format or if the URI is falsy.
   */


  exports.uriToOrd = function (uri) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!uri) {
      return baja.Ord.DEFAULT;
    }

    var match = uri.match(/^(https?)?(:\/\/)?([^:/]+)?(:(\d+))?(\/ord[/?])(.*)$/);

    if (!match) {
      return baja.Ord.DEFAULT;
    }

    var _match = _slicedToArray(match, 8),
        protocol = _match[1],
        host = _match[3],
        port = _match[5],
        ord = _match[7];

    var path = decodeURIComponent(ord);
    host = params.host || host;
    port = params.port || port;

    if (host) {
      var targetProtocol = params.protocol || (protocol === 'https' ? 'foxs' : 'fox');

      if (port) {
        host = host + ':' + port;
      }

      return baja.Ord.make("ip:".concat(host, "|").concat(targetProtocol, ":|").concat(path));
    } else {
      return baja.Ord.make(path);
    }
  };
  /**
   *
   * @param {module:bajaux/Widget} widget
   * @returns {Promise.<Array.<module:bajaux/commands/Command>>}
   */


  exports.resolveProfileCommands = function (widget) {
    return resolveMediaCommands(widget).then(function (mediaCommands) {
      return [].concat(_toConsumableArray(mediaCommands), [new ExportCommand(widget)]);
    });
  };
  /**
   * Resolve to the current View item if it is available.
   * @return {Promise.<module:profileInfo~ViewInfo|undefined>}
   */


  exports.resolveCurrentViewItem = function () {
    return exports.$resolveViewInfo().then(function (viewInfo) {
      if (viewInfo) {
        var list = viewInfo.list;
        return _.findWhere(list, {
          def: true
        }) || _.first(list);
      }
    });
  };
  /**
   * Return the current ViewId. This information is available from `hx`
   * even if the 'profileInfo' is not defined.
   * @return {Promise.<String|undefined>}
   */


  exports.resolveCurrentViewId = function () {
    return exports.resolveCurrentViewItem().then(function (viewItem) {
      if (viewItem) {
        var viewQuery = exports.getViewQuery(baja.Ord.make(viewItem.ord));

        if (viewQuery) {
          return viewQuery.getViewId();
        }
      }

      var hx = window.hx;

      if (hx && _.isFunction(hx.getProfileInfo)) {
        var profileInfo = hx.getProfileInfo();
        return profileInfo && profileInfo.viewId;
      }
    });
  };
  /**
   * Get the ViewQuery for an ord.
   * @param {baja.Ord} [ord] if the ord is not present, the `getCurrentOrd()` will be used.
   * @return {baja.ViewQuery|undefined}
   */


  exports.getViewQuery = function (ord) {
    var ordStr = getOrdStrFromParam(ord),
        viewIndex = getViewIndex(ordStr);

    if (viewIndex > -1) {
      var viewQueryBody = ordStr.substring(viewIndex + 5);
      return new baja.ViewQuery(viewQueryBody);
    }
  };
  /**
   * Get a View Parameter from the current `window.location.href`
   * @param {String} name
   * @return {String|undefined}
   */


  exports.getViewParameter = function (name) {
    var viewQuery = exports.getViewQuery();

    if (viewQuery) {
      var params = viewQuery.getParameters();
      return params[name];
    }
  };
  /**
   * Get the custom message provided by jetty from JQuery error handler
   * @param {JQuery.jqXHR} jqXHR
   * @param {String} textStatus
   * @param {errorThrown} errorThrown
   * @return {Error}
   */


  exports.getServletError = function (jqXHR, textStatus, errorThrown) {
    var responseText = jqXHR.responseText; //jetty provides HTML to get to local error message so we must generate an HTML page and parse it from there.

    var message = $(responseText).find('tr:nth-child(3) td').text();

    if (!message && errorThrown) {
      message = String(errorThrown);
    }

    if (!message) {
      message = textStatus;
    }

    return new Error(message);
  };
  /**
   * Get the browser's `window.location.href`.
   * @private
   * @return {String}
   */


  exports.$getLocation = function () {
    return window.location.href;
  };
  /**
   * If `profileInfo` is not defined, this will resolve to an `undefined` value,
   * This will happen for profile's other than the Html5HxProfile and it will
   * happen within the Html5HxProfile when the page was loaded as a popup.
   * @return {Promise}
   * @private
   */


  exports.$requireProfileInfo = function () {
    if (require.specified('profileInfo')) {
      return doRequire('profileInfo');
    }

    return Promise.resolve();
  };
  /**
   * @return {Promise}
   * @private
   */


  exports.$resolveViewInfo = function () {
    return exports.$requireProfileInfo().then(function (profileInfo) {
      if (profileInfo) {
        return profileInfo.getViewInfo();
      }
    });
  };
  /**
   * @param {module:bajaux/Widget} widget
   * @return {Promise}
   */


  function resolveMediaCommands(widget) {
    return Promise.all([exports.resolveCurrentViewItem(), exports.$requireProfileInfo()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          item = _ref2[0],
          profileInfo = _ref2[1];

      if (profileInfo && profileInfo.isMediaCommandAvailable() && (item.px || item.moduleName === 'hx' && item.typeName === 'HxPxView')) {
        return doRequire('nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget').then(function (MediaSettingsWidget) {
          return MediaSettingsWidget.makeCommands(widget.getOrd());
        });
      }

      return [];
    });
  }
  /**
   *
   * @param {baja.Ord} [ord] if the ord is not present, the `getCurrentOrd()` will be used.
   * @return {String}
   */


  function getOrdStrFromParam(ord) {
    if (!ord) {
      ord = exports.getCurrentOrd();
    }

    ord = ord.normalize(); //ensure there is only one view query

    return String(ord);
  }
  /**
   * @param {String} ordStr
   * @return {Number}
   */


  function getViewIndex(ordStr) {
    return ordStr.indexOf('view:');
  }

  return exports;
});
