function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/profile/paletteSideBar
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.profile.paletteSideBar', 'bajaux/events', 'Promise', 'underscore', 'nmodule/webEditors/rc/util/storageUtil', 'nmodule/webEditors/rc/wb/shell/TitlePane', 'nmodule/webEditors/rc/wb/tree/PaletteNavTree', 'nmodule/webEditors/rc/servlets/palette'], function (baja, log, events, Promise, _, storageUtil, TitlePane, PaletteNavTree, palette) {
  'use strict';

  var getLocalStorage = storageUtil.getLocalStorage,
      logSevere = log.severe.bind(log),
      INVOKE_EVENT = events.command.INVOKE_EVENT,
      DEFAULT_PALETTES = ['alarm', 'baja', 'control', 'history', 'kitControl', 'schedule'];

  function paletteStorageKey() {
    return baja.getUserName() + '.profile.openPalettes';
  }

  function getOpenPalettes() {
    try {
      var openPalettes = getLocalStorage().getItem(paletteStorageKey());

      if (openPalettes) {
        return JSON.parse(openPalettes);
      }
    } catch (e) {}

    return DEFAULT_PALETTES;
  }

  function savePalettes(paletteNames) {
    try {
      getLocalStorage().setItem(paletteStorageKey(), JSON.stringify(paletteNames));
    } catch (e) {}
  }
  /**
   * Loads the Palette Sidebar.
   *
   * @inner
   * @private
   *
   * @param {JQuery} dom The jQuery DOM wrapper for the DOM to load the Sidebar into.
   */


  return function load(dom) {
    dom.one("sidebar-layout", function () {
      var titlePane = new TitlePane(),
          navTree = new PaletteNavTree(),
          moduleNames = getOpenPalettes();
      Promise.all([palette.getPalettes(moduleNames), titlePane.initialize(dom)]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
            paletteNode = _ref2[0];

        dom.on(INVOKE_EVENT, function (e, cmd) {
          navTree.value().getKids().then(function (kids) {
            var openPalettes = _.map(kids, function (kid) {
              return kid.getName();
            });

            savePalettes(openPalettes);
          })["catch"](logSevere);
        });
        return titlePane.setContentWidget(navTree).then(function () {
          return titlePane.load(paletteNode);
        });
      })["catch"](logSevere);
    });
  };
});
