function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson.
 */

/**
 * API Status: **Private**
 *
 * Loads the Nav Tree Sidebar.
 *
 * @module nmodule/webEditors/rc/wb/profile/navTreeSideBar
 */
define(["baja!", "log!nmodule.webEditors.rc.wb.profile.navTreeSideBar", "Promise", "nmodule/js/rc/asyncUtils/asyncUtils", "nmodule/webEditors/rc/servlets/navMonitor", "nmodule/webEditors/rc/wb/shell/TitlePane", "nmodule/webEditors/rc/wb/mixin/ContextMenuSupport", "nmodule/webEditors/rc/wb/mixin/NavMonitorSupport", "nmodule/webEditors/rc/wb/tree/stationTree", "nmodule/webEditors/rc/wb/tree/NavTree", "nmodule/webEditors/rc/fe/baja/util/spaceUtils"], function (baja, log, Promise, asyncUtils, navMonitor, TitlePane, addContextMenuSupport, addNavMonitorSupport, stationTree, NavTree, spaceUtils) {
  'use strict';

  var logError = log.severe.bind(log),
      doRequire = asyncUtils.doRequire,
      resolveService = spaceUtils.resolveService; //TODO: can we clear session storage on logout? !this is important for security reasons

  /**
   * Get the path of nav names down through the nav file for this node, starting
   * with the root.
   *
   * @inner
   * @private
   *
   * @param {baja.NavContainer} node
   * @returns {Array.<String>}
   */

  function parseNavFilePath(node) {
    return node ? parseNavFilePath(node.getNavParent()).concat([node.getNavName()]) : [];
  }
  /**
   * Parse the current ORD into a path that can be loaded into a Nav Tree.
   *
   * @inner
   * @private
   *
   * @returns {Promise.<Array.<string>>|Array.<string>} an array of strings that
   * map to a path to load into the Nav Tree, or a promise that resolves to
   * same
   * @throws {Error} if the ORD could not be parsed
   */


  function parsePath(ord, stationName) {
    ord = baja.Ord.make(ord).relativizeToSession();
    var navFileNode = baja.nav.navfile.lookup('local:|' + ord),
        query = ord.parse(),
        slotPath = query.get("slot"),
        historyPath = query.get("history"),
        hierarchyPath = query.get("hierarchy"),
        servicePath = query.get("service"),
        filePath = query.get("file"),
        handlePath = query.get("h"),
        virtualPath = query.get("virtual"),
        nspacePath = query.get("nspace"),
        body = "";

    if (navFileNode) {
      return ['local'].concat(parseNavFilePath(navFileNode));
    }

    if (servicePath || handlePath) {
      return ord.get().then(function (obj) {
        body = "local/station" + obj.toPathString();
        return body.split('/');
      });
    } else if (filePath) {
      body = "local/file/" + filePath.getBody().replace(/^\^/, '');

      if (slotPath) {
        body += slotPath.getBody();
      }
    } else if (slotPath) {
      body = "local/station" + slotPath.getBody();

      if (virtualPath) {
        body = body + virtualPath.getBody();
      } else if (nspacePath && nspacePath.getBody() && nspacePath.getBody() !== stationName) {
        return getRemoteStationVirtualPath(nspacePath.getBody()).then(function (virtualPath) {
          body = "local/station" + virtualPath + slotPath.getBody();
          return body.split('/');
        });
      }
    } else if (historyPath) {
      body = historyPath.getBody();
      body = body.replace("^", "/" + stationName + "/");
      body = "local/history" + body;
    } else if (hierarchyPath) {
      body = hierarchyPath.getBody(); // Inject a prefix to ensure that hierarchies have a unique name. This will
      // help stop issues when the hierarchy has the same name as one of the
      // other sibling tree nodes.

      if (body && body.charAt(0) === '/') {
        body = '/' + stationTree.HIERARCHY_NODE_PREFIX + body.substring(1, body.length);
      }

      body = "local" + body; // Need to escape each name individually instead of the entire hierarchy path at once.  The
      // hierarchy path needs to be split on the forward slashes that exist before escaping because
      // individual names may have forward slashes after escaping that need to stay together.  For
      // example, /myHierarchy/grouping1/grouping2/nspace:remoteStation|slot:/A/B/C should be
      // transformed into [local, hierarchy-node-myHierarchy, grouping1, grouping2,
      // nspace:remoteStation|slot:/A/B/C] and not [local, hierarchy-node-myHierarchy, grouping1,
      // grouping2, nspace:remoteStation|slot:, A, B, C]

      return body.split('/').map(baja.SlotPath.unescape);
    } else if (nspacePath) {
      body = "local/station";

      if (nspacePath.getBody() && nspacePath.getBody() !== stationName) {
        return getRemoteStationVirtualPath(nspacePath.getBody()).then(function (virtualPath) {
          body += virtualPath;

          if (slotPath) {
            body += slotPath.getBody();
          }

          return body.split('/');
        });
      }
    } else {
      throw new Error('unrecognized ORD ' + ord);
    }

    return body.split('/');
  }
  /**
   *
   * @private
   * @param {String} stationName the remote station name
   * @returns {Promise} Resolves to path that helps resolve to the virtual component space
   */


  function getRemoteStationVirtualPath(stationName) {
    return resolveService("niagaraDriver:NiagaraNetwork").then(function (nNetwork) {
      return nNetwork.getSlotPath().getBody() + "/" + stationName + "/virtual";
    });
  }
  /**
   * Load the Nav Tree.
   *
   * @inner
   * @private
   *
   * @param {JQuery} dom The jQuery DOM to load the Nav Tree into.
   * @param {Function} hyperlinkFunc A function used to hyperlink to a
   * URI.
   * @param {Object} params Loading options for the Nav Tree.
   */


  function navTreeSideBar(dom, hyperlinkFunc, params) {
    dom.one("sidebar-layout", function () {
      var titlePane = new TitlePane(),
          navTree;
      stationTree.createNavTree({
        loadKids: false,
        enableHoverPreload: true
      }).then(function (tree) {
        navTree = tree;
        addContextMenuSupport(navTree);
        addNavMonitorSupport(navTree); //whenever a nav tree node is expanded, request an immediate touch.
        //see javax.baja.workbench.nav.tree.NavTreeNode#expand().

        dom.on(NavTree.EXPANDED_EVENT, function () {
          navTree.emit(navMonitor.REQUEST_TOUCH_EVENT);
        });
        return titlePane.initialize(dom);
      }).then(function () {
        dom.on(NavTree.ACTIVATED_EVENT, function (e, ed) {
          var node = ed.value();
          node.toHyperlinkUri().then(function (uri) {
            if (uri) {
              hyperlinkFunc(uri);
            } else {
              ed.$setExpanded(!ed.$isExpanded())["catch"](logError);
            }
          })["catch"](logError);
        });
        return Promise.all([doRequire("profileInfo"), stationTree.makeRootNode(params), titlePane.setContentWidget(navTree)]);
      }).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            profileInfo = _ref2[0],
            rootNode = _ref2[1];

        return Promise.all([parsePath(profileInfo.getOrd(), profileInfo.getStationName()), titlePane.load(rootNode)]);
      }).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 1),
            path = _ref4[0];

        //should loading spinner stay up until setSelectedPath completes? if so, return this
        navTree.setSelectedPath(path)["catch"](logError);
        return null; //squelch "promise not returned"
      })["catch"](logError);
    });
  }

  navTreeSideBar.$parsePath = parsePath;
  return navTreeSideBar;
});
