function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
 */
define(['baja!', 'jquery', 'lex!webEditors', 'log!nmodule.webEditors.rc.wb.profile.media.MediaSettingsWidget', 'bajaux/commands/Command', 'bajaux/events', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/wb/profile/media/MediaSettings', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/wb/profile/profileUtils'], function (baja, $, lexs, log, Command, events, switchboard, MediaSettings, OrderedMapEditor, feDialogs, CompositeEditor, CompositeBuilder, profileUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      webEditorsLex = _lexs[0];

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var logSevere = log.severe.bind(log);
  var HX_MEDIA_TYPE = 'hx:HxPxMedia';
  var UX_MEDIA_TYPE = 'uxBuilder:UxMedia';
  var MEDIA_TYPE = webEditorsLex.getSafe('changeMediaType'),
      PREVIEW_UX = webEditorsLex.getSafe('previewUx'),
      PREVIEW_HX = webEditorsLex.getSafe('previewHx'),
      PRESERVE_IDENTITIES = webEditorsLex.getSafe('preserveIdentities'),
      AUDITION_MODE = webEditorsLex.getSafe('auditionMode'),
      AUDITION_INDEX = webEditorsLex.getSafe('auditionIndex'),
      SHOW_VALIDATION_WARNINGS = webEditorsLex.getSafe('showValidationWarnings'),
      VALIDATION_WARNINGS = webEditorsLex.getSafe('validationWarnings');
  var KEYS_TO_TYPE = {
    'mediaType': 'baja:String',
    'previewUx': 'baja:Boolean',
    'previewHx': 'baja:Boolean',
    'preserveIdentities': 'baja:Boolean',
    'auditionMode': 'baja:Boolean',
    'auditionIndex': 'baja:Integer',
    'showValidationWarnings': 'baja:Boolean',
    'validationWarnings': 'baja:String'
  };
  var MEDIA_TYPES;

  var getKeys = function getKeys() {
    return Object.keys(KEYS_TO_TYPE);
  };

  var tpl = function tpl() {
    return "\n    <table class=\"ux-table\">\n      <tr class=\"ux-table-row\"><td>".concat(MEDIA_TYPE, "</td><td class=\"mediaType\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(PREVIEW_UX, "</td><td class=\"previewUx\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(PREVIEW_HX, "</td><td class=\"previewHx\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(PRESERVE_IDENTITIES, "</td><td class=\"preserveIdentities\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(AUDITION_MODE, "</td><td class=\"auditionMode\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(AUDITION_INDEX, "</td><td class=\"auditionIndex\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(SHOW_VALIDATION_WARNINGS, "</td><td class=\"showValidationWarnings\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(VALIDATION_WARNINGS, "</td><td class=\"validationWarnings\"></td></tr>\n    </table>");
  };
  /**
   * Allows configuration of Media settings.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */


  var MediaSettingsWidget = /*#__PURE__*/function (_CompositeEditor) {
    _inherits(MediaSettingsWidget, _CompositeEditor);

    var _super = _createSuper(MediaSettingsWidget);

    function MediaSettingsWidget(params) {
      var _this;

      _classCallCheck(this, MediaSettingsWidget);

      _this = _super.call(this, params);
      switchboard(_assertThisInitialized(_this), {
        $handleModify: {
          allow: 'oneAtATime',
          onRepeat: 'returnLast'
        }
      });
      return _this;
    }

    _createClass(MediaSettingsWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        return Promise.resolve(MEDIA_TYPES || MediaSettings.makeMediaMap()).then(function (map) {
          if (!MEDIA_TYPES) {
            MEDIA_TYPES = map;
          }

          dom.addClass('MediaSettingsWidget').html(tpl());
          dom.on(MODIFY_EVENT, '*', function (event) {
            _this2.$handleModify(event);
          });
        });
      }
      /**
       * Update the Widget when the settings have been retrieved.
       * @param {jQuery.Event} event
       */

    }, {
      key: "$handleModify",
      value: function $handleModify(event) {
        var _this3 = this;

        var settings;
        this.read().then(function (readSettings) {
          settings = readSettings;
          settings.saveToStorage();
          return _this3.$updateRows(settings);
        }).then(function () {
          var target = $(event.target);

          var builder = _this3.getBuilder();

          if (target.hasClass('auditionMode')) {
            return settings.resolveMediaInfo({
              auditionModeRemove: !settings.auditionMode
            }).then(function (results) {
              return builder.getEditorFor("auditionIndex").load(results.auditionIndex || 0);
            });
          } else if (target.hasClass('mediaType') || target.hasClass('showValidationWarnings') || target.hasClass('previewUx') || target.hasClass('previewHx')) {
            if (settings.showValidationWarnings) {
              var _settings = settings,
                  mediaType = _settings.mediaType;

              if (settings.previewUx) {
                mediaType = UX_MEDIA_TYPE;
              } else if (settings.previewHx) {
                mediaType = HX_MEDIA_TYPE;
              }

              return settings.resolveMediaInfo({
                mediaType: mediaType
              }).then(function () {
                var builder = _this3.getBuilder();

                return builder.getEditorFor("validationWarnings").load(settings.validationWarnings);
              });
            }
          }
        })["catch"](logSevere);
      }
      /**
       * Update row visibility and readonly states.
       * @private
       * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} settings
       * @return {Promise}
       */

    }, {
      key: "$updateRows",
      value: function $updateRows(settings) {
        var builder = this.getBuilder(),
            modifiedMedia = settings.mediaType !== this.$defaultSettings.mediaType,
            readonlyPreview = modifiedMedia,
            auditionMode = settings.auditionMode,
            isPxFile = settings.isPxFile,
            previewUx = settings.previewUx,
            previewHx = settings.previewHx,
            showValidationWarnings = settings.showValidationWarnings;
        var uxViewParam = profileUtils.getViewParameter('ux');
        var previewHxVisible = uxViewParam === 'false';
        builder.getDomFor("previewHx").parent().toggle(previewHxVisible);
        builder.getDomFor("validationWarnings").parent().toggle(showValidationWarnings);
        builder.getDomFor("auditionIndex").parent().toggle(auditionMode);
        builder.getDomFor("preserveIdentities").parent().toggle(!!isPxFile && modifiedMedia);
        return Promise.all([builder.getEditorFor("previewUx").setReadonly(readonlyPreview || previewHx), builder.getEditorFor("previewHx").setReadonly(readonlyPreview || previewUx), readonlyPreview && builder.getEditorFor("previewUx").load(false), readonlyPreview && builder.getEditorFor("previewHx").load(false), builder.getEditorFor("mediaType").setReadonly(previewUx || previewHx)]);
      }
      /**
       * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder} a builder
       * to show selectors for each media setting property.
       */

    }, {
      key: "makeBuilder",
      value: function makeBuilder() {
        var _this4 = this;

        var that = this;
        var builder = new CompositeBuilder();
        builder.getKeys = getKeys;

        builder.getDomFor = function (key) {
          return that.jq().find('.' + key);
        };

        builder.getValueFor = function (key) {
          if (key === "mediaType") {
            return MEDIA_TYPES;
          } else {
            return baja.$(KEYS_TO_TYPE[key], _this4.$defaultSettings[key]);
          }
        };

        builder.getConfigFor = function (key) {
          if (key === "mediaType") {
            return {
              type: OrderedMapEditor,
              properties: {
                lexicon: 'webEditors',
                lexiconIcons: true
              },
              //loadParams: { selectedValue: this.$defaultSettings[key] }, //getConfigFor does not seem to support this
              formFactor: 'mini'
            };
          } else if (key === "auditionIndex" && that.$auditionSize) {
            return {
              properties: {
                min: 0,
                max: that.$auditionSize - 1
              },
              formFactor: 'mini'
            };
          } else if (key === "validationWarnings") {
            return {
              properties: {
                multiLine: true,
                fieldWidth: 60
              },
              readonly: true,
              formFactor: 'mini'
            };
          }

          return {
            formFactor: 'mini'
          };
        };

        builder.$loadFor = function (key) {
          var params = {};

          if (key === "mediaType") {
            params = {
              selectedValue: _this4.$defaultSettings[key]
            };
          }

          return CompositeBuilder.prototype.$loadFor.apply(builder, [key, params]);
        };

        return builder;
      }
      /**
       * Load in the current configured settings (either saved by the user or the defaults).
       *
       * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} mediaSettings
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(mediaSettings) {
        var _arguments = arguments,
            _this5 = this;

        var mediaType;
        var uxViewParam = profileUtils.getViewParameter('ux'),
            isUxPreview = uxViewParam === 'true',
            isHxPreview = uxViewParam === 'false';

        if (isUxPreview) {
          mediaType = UX_MEDIA_TYPE;
        } else if (isHxPreview) {
          mediaType = HX_MEDIA_TYPE;
        }

        this.$ord = mediaSettings.ord;
        return mediaSettings.resolveMediaInfo({
          mediaType: mediaType
        }).then(function (readSettings) {
          _this5.$defaultSettings = readSettings;
          _this5.$auditionSize = readSettings.auditionSize;
          _this5.$isPxFile = mediaSettings.isPxFile;
          readSettings.previewUx = isUxPreview;
          readSettings.previewHx = isHxPreview;
          return _get(_getPrototypeOf(MediaSettingsWidget.prototype), "doLoad", _this5).apply(_this5, _arguments).then(function () {
            return _this5.$updateRows(readSettings);
          });
        });
      }
      /**
       * Read user-entered settings.
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/profile/media/MediaSettings>}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        var _this6 = this;

        var keys = getKeys();
        var builder = this.getBuilder();
        return Promise.all(keys.map(function (key) {
          return builder.getEditorFor(key).read();
        })).then(function (enums) {
          var settings = {
            ord: _this6.$ord,
            auditionSize: _this6.$auditionSize,
            isPxFile: _this6.$isPxFile
          };
          keys.forEach(function (key, i) {
            settings[key] = enums[i].valueOf();
          });
          return new MediaSettings(settings);
        });
      }
    }, {
      key: "doSave",
      value: function doSave(value) {
        //don't modify the file unless the mediaType has been modified
        if (this.$defaultSettings.mediaType === value.mediaType) {
          value.mediaType = "";
        }

        return value.saveMediaInfo(value);
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('MediaSettingsWidget');
        return _get(_getPrototypeOf(MediaSettingsWidget.prototype), "doDestroy", this).call(this);
      }
      /**
       * @param {baja.Ord} ord
       * @returns {Array.<module:bajaux/commands/Command>}
       */

    }], [{
      key: "makeCommands",
      value: function makeCommands(ord) {
        var mediaSettings = MediaSettings.make(ord);

        if (mediaSettings.auditionMode) {
          return [new PreviousMediaCommand(mediaSettings), new NextMediaCommand(mediaSettings), new MediaCommand(mediaSettings)];
        } else {
          return [new MediaCommand(mediaSettings)];
        }
      }
    }]);

    return MediaSettingsWidget;
  }(CompositeEditor);
  /**
   * Launch the Media Settings Dialog.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
   * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} mediaSettings
   */


  var MediaCommand = /*#__PURE__*/function (_Command) {
    _inherits(MediaCommand, _Command);

    var _super2 = _createSuper(MediaCommand);

    function MediaCommand(mediaSettings) {
      _classCallCheck(this, MediaCommand);

      return _super2.call(this, {
        module: 'webEditors',
        lex: 'commands.mediaCommand',
        func: function func() {
          return feDialogs.showFor({
            title: webEditorsLex.getSafe('commands.mediaCommand.displayName'),
            value: mediaSettings,
            type: MediaSettingsWidget
          });
        }
      });
    }

    return MediaCommand;
  }(Command);
  /**
   * Navigate to the previous auditionIndex.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
   * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} mediaSettings
   */


  var PreviousMediaCommand = /*#__PURE__*/function (_Command2) {
    _inherits(PreviousMediaCommand, _Command2);

    var _super3 = _createSuper(PreviousMediaCommand);

    function PreviousMediaCommand(mediaSettings) {
      _classCallCheck(this, PreviousMediaCommand);

      return _super3.call(this, {
        module: 'webEditors',
        lex: 'commands.previousMediaCommand',
        func: function func() {
          return mediaSettings.auditionNavigation(false);
        }
      });
    }

    return PreviousMediaCommand;
  }(Command);
  /**
   * Navigate to the next auditionIndex.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
   * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} mediaSettings
   */


  var NextMediaCommand = /*#__PURE__*/function (_Command3) {
    _inherits(NextMediaCommand, _Command3);

    var _super4 = _createSuper(NextMediaCommand);

    function NextMediaCommand(mediaSettings) {
      _classCallCheck(this, NextMediaCommand);

      return _super4.call(this, {
        module: 'webEditors',
        lex: 'commands.nextMediaCommand',
        func: function func() {
          return mediaSettings.auditionNavigation(true);
        }
      });
    }

    return NextMediaCommand;
  }(Command);

  return MediaSettingsWidget;
});
