function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/profile/media/MediaSettings
 */
define(['baja!', 'jquery', 'underscore', 'nmodule/js/rc/csrf/csrfUtil', 'nmodule/webEditors/rc/util/storageUtil', 'nmodule/webEditors/rc/servlets/registry', 'nmodule/webEditors/rc/wb/profile/profileUtils'], function (baja, $, _, csrfUtil, storageUtil, registry, profileUtils) {
  'use strict';

  var SESSION_DATA_KEY = 'MediaSettings';
  var DEFAULT_MEDIA_TYPE = 'workbench:WbPxMedia';
  var UX_MEDIA_TYPE = 'uxBuilder:UxMedia';
  var DEFAULT_PREVIEW_UX = false;
  var DEFAULT_PREVIEW_HX = false;
  var DEFAULT_PRESERVE_IDENTITIES = false;
  var DEFAULT_IS_PX_FILE = false;
  var DEFAULT_AUDITION_MODE = false;
  var DEFAULT_AUDITION_INDEX = 0;
  var DEFAULT_SHOW_VALIDATION_WARNINGS = false;
  var DEFAULT_VALIDATION_WARNINGS = '';
  var getSessionStorage = storageUtil.getSessionStorage;
  /**
   * Media Settings.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/profile/media/MediaSettings
   */

  var MediaSettings = /*#__PURE__*/function () {
    /**
     * @param [params]
     * @param {string} params.ord
     * @param {string} params.mediaType
     * @param {boolean} params.previewUx
     * @param {boolean} params.previewHx
     * @param {boolean} params.preserveIdentities
     * @param {boolean} params.isPxFile
     * @param {boolean} params.auditionMode
     * @param {Number} params.auditionIndex
     * @param {Number} params.auditionSize is the size of the audition mode ords list
     * @param {boolean} params.showValidationWarnings
     */
    function MediaSettings() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _classCallCheck(this, MediaSettings);

      this.ord = params.ord;
      /** @type {string} */

      this.mediaType = params.mediaType || DEFAULT_MEDIA_TYPE;
      /** @type {boolean} */

      this.previewUx = params.previewUx || DEFAULT_PREVIEW_UX;
      /** @type {boolean} */

      this.previewHx = params.previewHx || DEFAULT_PREVIEW_HX;
      /** @type {boolean} */

      this.preserveIdentities = params.preserveIdentities || DEFAULT_PRESERVE_IDENTITIES;
      /** @type {boolean} */

      this.isPxFile = params.isPxFile || DEFAULT_IS_PX_FILE;
      /** @type {boolean} */

      this.auditionMode = params.auditionMode || DEFAULT_AUDITION_MODE;
      /** @type {Number} */

      this.auditionIndex = params.auditionIndex || DEFAULT_AUDITION_INDEX;
      /** @type {boolean} */

      this.showValidationWarnings = params.showValidationWarnings || DEFAULT_SHOW_VALIDATION_WARNINGS;
      /** @type {String} */

      this.validationWarnings = params.validationWarnings || DEFAULT_VALIDATION_WARNINGS;
      /** @type {Number} */

      this.auditionSize = params.auditionSize || 0;
    }
    /**
     * Retrieve the media settings for this `baja.Ord`. Will use the
     * settings saved by the user if present; otherwise the defaults will be used.
     *
     * @param {baja.Ord} ord
     * @returns {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings}
     */


    _createClass(MediaSettings, [{
      key: "resolveMediaInfo",

      /**
       *
       * @param {object} params
       * @param [params.mediaType] The desired media type for validation
       * @param [auditionModeRemove=false] a flag to cleanup the audition mode
       * @return {Promise}
       */
      value: function resolveMediaInfo() {
        var _this = this;

        var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            mediaType = _ref.mediaType,
            auditionModeRemove = _ref.auditionModeRemove;

        var ordString = getFullOrdString({
          ord: this.ord,
          auditionMode: this.auditionMode,
          showValidationWarnings: this.showValidationWarnings,
          mediaType: mediaType,
          auditionModeRemove: auditionModeRemove
        });
        return MediaSettings.$ajax('/uxBuilder/ux/media/' + ordString).then(function (resultsString) {
          var results = JSON.parse(resultsString);
          _this.mediaType = results.mediaType;
          _this.auditionIndex = results.auditionIndex;
          _this.validationWarnings = results.validationWarnings;
          _this.auditionSize = results.auditionSize;
          _this.isPxFile = results.isPxFile;
          return _this;
        });
      }
      /*
      * Given the current ord, return the next (or previous) Ord in the audition.
      * @param {boolean} next
      * @returns {Promise}
      */

    }, {
      key: "auditionNavigation",
      value: function auditionNavigation(next) {
        var _this2 = this;

        var ordString = getFullOrdString({
          ord: this.ord,
          auditionMode: this.auditionMode,
          next: next,
          applyIncrement: true
        });
        var nextOrd;
        return MediaSettings.$ajax('/uxBuilder/ux/media/' + ordString).then(function (resultsString) {
          var results = JSON.parse(resultsString);
          nextOrd = results.nextOrd;
          _this2.auditionIndex = results.auditionIndex;

          _this2.saveToStorage();

          if (_this2.previewUx) {
            niagara.env.hyperlink(nextOrd + "|view:?ux=true");
          } else if (_this2.previewHx) {
            niagara.env.hyperlink(nextOrd + "|view:?ux=false");
          } else {
            niagara.env.hyperlink(nextOrd);
          }
        });
      }
      /**
       * Persist changes to the station and/or obtain the next ord to review.
       * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} value
       * @return {Promise}
       */

    }, {
      key: "saveMediaInfo",
      value: function saveMediaInfo(value) {
        var _this3 = this;

        //don't save changes to mediaType if previewUx or previewHx is true
        if (value.previewUx || value.previewHx) {
          value.mediaType = "";
        }

        var ordString = getFullOrdString({
          ord: this.ord,
          auditionMode: this.auditionMode,
          mediaType: value.mediaType,
          auditionIndex: value.auditionIndex,
          preserveIdentities: value.preserveIdentities
        });
        return MediaSettings.$ajax('/uxBuilder/ux/media/' + ordString, {
          type: "POST"
        }).then(function (resultsString) {
          var results = JSON.parse(resultsString);
          var nextOrd = results.nextOrd;

          if (_this3.previewUx) {
            niagara.env.hyperlink(nextOrd + "|view:?ux=true");
          } else if (_this3.previewHx) {
            niagara.env.hyperlink(nextOrd + "|view:?ux=false");
          } else {
            niagara.env.hyperlink(nextOrd);
          }
        });
      }
      /**
       * Persist these settings to session.
       */

    }, {
      key: "saveToStorage",
      value: function saveToStorage() {
        var clone = JSON.parse(JSON.stringify(this));
        delete clone.ord;
        delete clone.validationWarnings;
        delete clone.isPxFile;
        getSessionStorage().setItem(SESSION_DATA_KEY, JSON.stringify(clone));
      }
      /**
       * @param {String} mediaType
       * @return {boolean}
       */

    }], [{
      key: "make",
      value: function make(ord) {
        var storedSettings = getSessionStorage().getItem(SESSION_DATA_KEY);
        var params = {};

        if (storedSettings) {
          params = JSON.parse(storedSettings);
        }

        params.ord = ord;
        return new MediaSettings(params);
      }
      /**
       * Make a Map of all the available PxMedia concrete Types.
       * @return {Promise<module:baja/sys/structures/OrderedMap>}
       */

    }, {
      key: "makeMediaMap",
      value: function makeMediaMap() {
        var map = new baja.OrderedMap();
        return registry.getTypes({
          targetType: 'bajaui:PxMedia',
          showAbstract: false,
          showInterface: false
        }).then(function (typeSpecs) {
          _.map(typeSpecs, function (typeSpec) {
            map.put("media." + typeSpec.type.split(":")[1], typeSpec.type);
          });

          return map;
        });
      }
    }, {
      key: "isUxMedia",
      value: function isUxMedia(mediaType) {
        return mediaType === UX_MEDIA_TYPE;
      }
      /**
       * Request an ajax call and use proper error handling for the Servlet response.
       * @param {String} uri
       * @param {Object} [params]
       * @returns {Promise}
       * @private
       */

    }, {
      key: "$ajax",
      value: function $ajax(uri, params) {
        // eslint-disable-next-line promise/avoid-new
        return new Promise(function (resolve, reject) {
          if (!params) {
            params = {};
          }

          if (!params.type) {
            params.type = "GET";
          }

          params.success = function (result) {
            resolve(result);
          };

          params.error = function () {
            reject(profileUtils.getServletError.apply(this, arguments));
          };

          if (params.type === "POST") {
            //Add the CSRF token for posts
            var token = csrfUtil.getCsrfToken();

            if (!params.headers) {
              params.headers = {
                'x-niagara-csrfToken': token
              };
            } else {
              params.headers['x-niagara-csrfToken'] = token;
            }
          }

          $.ajax(uri, params);
        });
      }
    }]);

    return MediaSettings;
  }();
  /**
   * Convert the parameters into a string, adding whatever additional arguments
   * are necessary to complete the query, and escaping it so that it can
   * be used as part of a URI.
   *
   * @param {Object} params
   * @param {baja.Ord} params.ord
   * @param {boolean} [params.auditionMode=false]
   * @param {boolean} [params.next=false]
   * @param {string} [params.mediaType='']
   * @param {Number} [params.auditionIndex=0]
   * @param {boolean} [params.showValidationWarnings=false]
   * @param {boolean} [params.auditionModeRemove=false]
   * @param {boolean} [params.applyIncrement=false]
   * @returns {string}
   */


  function getFullOrdString(params) {
    var ord = params.ord,
        auditionMode = params.auditionMode,
        next = params.next,
        mediaType = params.mediaType,
        auditionIndex = params.auditionIndex,
        showValidationWarnings = params.showValidationWarnings,
        auditionModeRemove = params.auditionModeRemove,
        applyIncrement = params.applyIncrement,
        preserveIdentities = params.preserveIdentities;
    var ordSuffix = '';

    function addParameter(str) {
      if (ordSuffix.length) {
        ordSuffix += '&';
      } else {
        ordSuffix += '?';
      }

      ordSuffix += str;
    }

    if (auditionMode) {
      addParameter('auditionMode=' + auditionMode);
    }

    if (auditionModeRemove) {
      addParameter('auditionModeRemove=' + auditionModeRemove);
    }

    if (mediaType) {
      addParameter('mediaType=' + baja.SlotPath.escape(mediaType));
    }

    if (next) {
      addParameter('next=' + next);
    }

    if (showValidationWarnings) {
      addParameter('showValidationWarnings=' + showValidationWarnings);
    }

    if (auditionIndex !== undefined) {
      addParameter('auditionIndex=' + auditionIndex);
    }

    if (applyIncrement) {
      addParameter('applyIncrement=' + applyIncrement);
    }

    if (preserveIdentities) {
      addParameter('preserveIdentities=' + preserveIdentities);
    }

    return baja.SlotPath.escape(ord.toString()) + ordSuffix;
  }

  return MediaSettings;
});
