function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*eslint-env browser */

/*jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/textEditorMixIn
 */
define(['baja!', 'lex!webEditors', 'jquery', 'bajaux/commands/Command', 'bajaux/util/SaveCommand', 'bajaux/Widget', 'ace/ace', 'dialogs', 'nmodule/webEditors/rc/wb/mixin/mixinUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/util/CommandButtonGroup'], function (baja, lexicons, $, Command, SaveCommand, Widget, ace, dialogs, mixinUtils, feDialogs, CommandButtonGroup) {
  "use strict";

  var applyMixin = mixinUtils.applyMixin,
      MIXIN_NAME = "textEditor",
      lex = lexicons[0],
      lastLoadedOrd = baja.Ord.DEFAULT; ////////////////////////////////////////////////////////////////
  // Text Editor Mix-In
  ////////////////////////////////////////////////////////////////

  /**
   * A Mix-In for a Widget that shows a text editor.
   * @alias module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
   */

  var exports = function exports(target) {
    if (!applyMixin(target, MIXIN_NAME)) {
      return;
    }

    var superInitialize = target.initialize,
        superDestroy = target.destroy,
        superLayout = target.layout;
    /**
     * Injects the editor into the Widget.
     *
     * @param dom The DOM element to initialize into.
     *
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     * @returns {Promise}
     */

    target.initialize = function (dom) {
      var that = this;
      return superInitialize.apply(that, arguments).then(function () {
        var ed = that.$editorDom = $("<div></div>");
        dom.append(ed);
        that.$editor = ace.edit(ed.get(0));
      });
    };
    /**
     * Destroys the Widget.
     *
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     * @returns {Promise}
     */


    target.destroy = function () {
      var that = this;
      return superDestroy.apply(that, arguments).then(function () {
        if (that.$editor) {
          that.$editor.destroy();
          that.$editor = null;
        }

        that.$editorDom = null;
      });
    };
    /**
     * Layout the Widget.
     *
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     * @returns {Promise}
     */


    target.layout = function () {
      var that = this,
          jq = that.jq();
      return superLayout.apply(that, arguments).then(function () {
        var parent = jq.parent();
        jq.css({
          width: parent.width(),
          height: parent.height()
        });

        if (that.$editorDom) {
          that.$editorDom.css({
            width: parent.width(),
            height: parent.height()
          });
        }

        if (that.$editor && that.$editor.env && typeof that.$editor.env.onResize === "function") {
          that.$editor.env.onResize();
        }
      });
    };
    /**
      * Adds a run command to the widget.
      *
      * @private
      * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
      */


    target.$addRunCmd = function () {
      var that = this,
          cmd;
      cmd = new Command({
        module: "webEditors",
        lex: "commands.runJs",
        func: function func() {
          var id = "dummyDefineFromTextEditor";

          function undef() {
            // Once the widget has run, deregister it from RequireJS.
            require.undef(id);
          }

          undef();
          var dummyDefineCalled, dummyDefineErr; // If it's a define then capture it with a dummy id. If it defines a widget the
          // attempt to launch it in a dialog.

          (function () {
            var define = function define() {
              dummyDefineCalled = true;
              var args = Array.prototype.slice.call(arguments);

              if (args.length === 1) {
                return window.define.apply(this, [id].concat(args));
              } else {
                return typeof args[0] === 'string' ? window.define.apply(this, args) : window.define.apply(this, [id].concat(args));
              }
            };

            define.amd = true;

            try {
              // eslint-disable-next-line no-eval
              eval(that.$editor.session.getValue());
            } catch (err) {
              dummyDefineErr = err;
            }
          })();

          if (dummyDefineErr) {
            dialogs.showOk({
              title: "Error",
              content: dummyDefineErr
            });
          } else if (dummyDefineCalled) {
            // Ask the user if they want to load a value into the widget. If so then select
            // the value.
            dialogs.showYesNo({
              title: lex.get("commands.runJs.displayName"),
              content: lex.get("commands.runJs.loadValueQuestion")
            }).promise().then(function (_ref) {
              var _ref2 = _slicedToArray(_ref, 2),
                  dlg = _ref2[0],
                  clickId = _ref2[1];

              if (clickId === "yes") {
                return feDialogs.showFor({
                  value: lastLoadedOrd,
                  title: lex.get("commands.runJs.selectValue"),
                  formFactor: Widget.formfactor.compact
                }).then(function (ord) {
                  if (ord) {
                    lastLoadedOrd = ord;
                  }

                  return ord;
                });
              }
            }).then(function (ord) {
              return ord && ord.toString() ? ord.get() : null;
            }).then(function (val) {
              // Now attempt to initialize the Widget. If the user has selected
              // a value then load it.
              require([id], function (NewWidget) {
                var widget, group;

                if (typeof NewWidget === "function") {
                  widget = new NewWidget();
                  group = new CommandButtonGroup({
                    properties: {
                      toolbar: true
                    }
                  });

                  if (widget instanceof Widget) {
                    $(window).one("jsdialog:show", function () {
                      if (widget) {
                        widget.layout();
                      }
                    });
                    dialogs.showOk({
                      content: function content(dlg, jq) {
                        jq.css('height', 600); // Hack the dialog so it fills the screen. This was added to help with the
                        // responsive layout mixin example in js playground.

                        dlg.jq().children('.js-dialog').css({
                          width: "100%"
                        });
                        jq.html("<div class='bajaux-container'>" + "<div class='bajaux-toolbar-outer'>" + "<div class='bajaux-toolbar'></div>" + "</div>" + "<div class='bajaux-widget-container'>" + "<div class='bajaux-widget'></div>" + "</div>" + "</div>");
                        var jqWidget = jq.find(".bajaux-widget"),
                            jqToolbar = jq.find(".bajaux-toolbar"),
                            promise = widget.initialize(jqWidget)["catch"](undef); // If the user has selected a value to load then load it.

                        if (val !== undefined && val !== null) {
                          promise = promise.then(function () {
                            return widget.load(val);
                          }).then(function () {
                            return widget.layout();
                          })["catch"](undef);
                        }

                        return promise.then(function () {
                          return group.initialize(jqToolbar);
                        }).then(function () {
                          return group.load(widget.getCommandGroup());
                        });
                      },
                      layout: function layout(dlg) {
                        widget.layout();
                      }
                    }).promise()["finally"](function () {
                      widget.destroy().then(function () {
                        return group.destroy();
                      })["finally"](undef);
                    });
                  } else {
                    undef();
                  }
                } else {
                  undef();
                }
              }, undef);
            })["catch"](undef);
          }
        }
      });
      cmd.$runCmd = true;
      that.getCommandGroup().add(cmd);
    };
    /**
     * Adds a save command to the Widget.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     */


    target.$addSaveCmd = function () {
      var that = this,
          foundSaveCmd; // Detect to see if a save command has already been added (i.e. from Dashboards).

      that.getCommandGroup().visit(function (cmd) {
        if (cmd.$saveCmd) {
          foundSaveCmd = true;
        }
      });

      if (!foundSaveCmd) {
        that.getCommandGroup().add(new SaveCommand());
      }
    };
    /**
     * Initializes the editor. This should be called just before the editor is loaded.
     *
     * @param {String} mode The editor's mode. This can be 'javascript', 'css', 'html',
     * 'xml', 'java', 'json', 'less', 'handlebars' or 'velocity'.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     */


    target.$initEditor = function (mode) {
      var that = this,
          editor = that.$editor;
      mode = that.$mode = "ace/mode/" + (mode || "text");
      editor.setTheme("ace/theme/chrome");
      editor.getSession().setMode(mode);
      editor.getSession().setTabSize(2);
      that.getCommandGroup().add(new Command({
        module: "webEditors",
        lex: "commands.find",
        func: function func() {
          editor.execCommand("find");
        }
      }));
      that.$replaceCmd = new Command({
        module: "webEditors",
        lex: "commands.replace",
        func: function func() {
          editor.execCommand("replace");
        }
      });
    };
    /**
     * Sets the editor as readonly or not.
     *
     * @param {Boolean} readonly If true, the editor is set to readonly.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     */


    target.$setEditorReadOnly = function (readonly) {
      var that = this,
          cg = that.getCommandGroup(),
          foundReplaceCmd = !!cg.findCommand(that.$replaceCmd.getId());
      that.$editor.setReadOnly(readonly);

      if (readonly && foundReplaceCmd) {
        cg.remove(that.$replaceCmd);
      } else if (!readonly && !foundReplaceCmd) {
        cg.add(that.$replaceCmd);
      }
    };
    /**
     * Register a function to be invoked when the editor's text is changed
     * by a user.
     *
     * @param  {Function} func The function to be called when the editor is changed.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     */


    target.$onEditorChange = function (func) {
      this.$editor.session.on("change", func);
    };
    /**
     * Return the text currently being displayed by the editor.
     *
     * @returns {String} The text the editor is current displaying.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     */


    target.$getEditorText = function () {
      return this.$editor.session.getValue();
    };
    /**
     * Set the text to be displayed in the editor.
     *
     * @param {String} text The text to be displayed in the editor.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/TextEditorMixIn
     */


    target.$setEditorText = function (text) {
      this.$editor.session.setValue(text);
    };
  };

  return exports;
});
