function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara*/

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/PropertySheetRowLinkSupport
 */
define(['baja!', 'lex!webEditors', 'log!nmodule.webEditors.rc.wb.mixin.PropertySheetRowLinkSupport', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'dialogs', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/Switchboard', 'nmodule/webEditors/rc/wb/links/LinkEditor', 'nmodule/webEditors/rc/wb/mixin/mixinUtils', 'css!nmodule/webEditors/rc/wb/mixin/PropertySheetRowLinkSupport'], function (baja, lexs, log, Command, CommandGroup, CommandButtonGroup, dialogs, $, Promise, _, feDialogs, Switchboard, LinkEditor, mixinUtils) {
  'use strict';

  var applyMixin = mixinUtils.applyMixin,
      webEditorsLex = lexs[0],
      logSevere = log.severe.bind(log),
      MIXIN_NAME = 'linkSupport';

  function isComponent(comp) {
    return baja.hasType(comp, 'baja:Component');
  }

  function isMounted(comp) {
    return isComponent(comp) && comp.isMounted();
  }

  function canEditLinks(comp) {
    return isMounted(comp) && comp.getPermissions().hasAdminWrite();
  }

  function toLinkTargets(arr) {
    return _.map(arr, function (obj) {
      return new LinkTarget(obj);
    });
  }
  /**
   * @inner
   * @param {Array.<LinkTarget>} linkTargets
   * @returns {Promise} promise to be resolved with a CommandGroup
   */


  function toCommandGroup(linkTargets) {
    return Promise.all(_.invoke(linkTargets, 'toCommand')).then(function (commands) {
      return new CommandGroup({
        commands: commands
      });
    });
  }

  function LinkTarget(obj) {
    if (baja.hasType(obj, 'baja:Link')) {
      this.ord = obj.getSourceOrd();
      this.slot = obj.getSourceSlotName();
    } else {
      this.ord = obj.getTargetOrd();
      this.slot = obj.getTargetSlotName();
    }
  }

  LinkTarget.prototype.toCommand = function () {
    var ord = this.ord,
        slot = this.slot;
    return getComponentAndNavOrd(ord).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          comp = _ref2[0],
          ord = _ref2[1];

      var displayName = comp.getDisplayName() + '/' + slot,
          description = ord + '/' + slot;
      return new Command({
        displayName: displayName,
        description: description,
        func: function func() {
          //TODO: selfClosing should work here. figure out why this.trigger(VALUE_READY_EVENT) does not work in a CommandButtonGroup
          dialogs.each(function (i, dlg) {
            dlg.close();
          });
          return niagara.env.hyperlink(ord);
        }
      });
    });
  };
  /**
   * Update the contents of either an incoming or outgoing links display.
   *
   * @inner
   * @param {JQuery} dom the element showing incoming or outgoing links
   * @param {String} display display text of the linked component
   * @param {String} [slot] name of the linked slot
   * @param {String} [title] `title` attribute (tooltip contents)
   */


  function updateLinkText(dom, display, slot, title) {
    dom.find('.display').text(display);
    dom.attr('title', title || display);
    dom.find('.subtitle').text(slot || '');
  }
  /**
   * Given an ord, resolve the component it points to and said component's
   * nav ord.
   *
   * @inner
   * @param {baja.Ord|String} ord (since this is coming from a Link, it's
   * almost certainly a handle ORD)
   * @returns {Promise} promise to be resolved with an array containing
   * a Component and ORD string, or empty if the ord can't be resolved
   */


  function getComponentAndNavOrd(ord) {
    //TODO: is this the right way to do this?
    return baja.Ord.make(ord).resolve({
      base: baja.station
    }) //most likely a handle - need base
    .then(function (target) {
      var comp = target.getComponent(),
          ord = comp.getNavOrd().relativizeToSession();
      return [comp, ord];
    }, function (ignore) {
      return [];
    });
  }
  /**
   *
   * @param complex
   * @param slot
   * @returns {Array}
   */


  function getUsableLinks(complex, slot) {
    if (!isComponent(complex)) {
      return [];
    }

    var links = complex.getLinks(slot),
        navOrd = complex.getNavOrd();
    return _.map(links, function (link) {
      if (baja.Ord.DEFAULT.equivalent(link.getSourceOrd())) {
        return baja.$('baja:Link', {
          sourceOrd: navOrd,
          sourceSlotName: link.getSourceSlotName(),
          targetSlotName: link.getTargetSlotName()
        });
      }

      return link;
    });
  }

  function getUsableKnobs(complex, slot) {
    if (!isComponent(complex)) {
      return [];
    }

    var knobs = complex.getKnobs(slot),
        navOrd = complex.getNavOrd();
    return _.map(knobs, function (knob) {
      if (baja.Ord.DEFAULT.equivalent(knob.getTargetOrd())) {
        return {
          getSourceSlotName: function getSourceSlotName() {
            return knob.getSourceSlotName();
          },
          getTargetOrd: function getTargetOrd() {
            return navOrd;
          },
          getTargetSlotName: function getTargetSlotName() {
            return knob.getTargetSlotName();
          }
        };
      }

      return knob;
    });
  }
  /**
   * When applied to a `PropertySheetRow`, enables incoming/outgoing links to
   * appear if the corresponding slot on the Complex has links.
   *
   * @private
   * @exports nmodule/webEditors/rc/wb/mixin/PropertySheetRowLinkSupport
   * @mixin
   */


  var exports = {
    /**
     * Get the element containing the incoming links display.
     *
     * @private
     * @returns {JQuery}
     */
    $getIncomingLinksElement: function $getIncomingLinksElement() {
      return this.jq().children('.col-display').find('.incoming.links');
    },

    /**
     * Get the element containing the outgoing links display.
     *
     * @private
     * @returns {JQuery}
     */
    $getOutgoingLinksElement: function $getOutgoingLinksElement() {
      return this.jq().children('.col-spacer').find('.outgoing.links');
    },

    /**
     * Shows/hides the incoming links display at the left edge of the row.
     *
     * @private
     */
    $toggleIncomingLinks: function $toggleIncomingLinks() {
      var jq = this.jq();
      return Promise.resolve(!jq.hasClass('show-incoming') && this.$updateIncomingLinks()).then(function () {
        jq.toggleClass('show-incoming').removeClass('show-outgoing');
      });
    },

    /**
     * Shows/hides the outgoing links display at the right edge of the row.
     *
     * @private
     */
    $toggleOutgoingLinks: function $toggleOutgoingLinks() {
      var jq = this.jq();
      return Promise.resolve(!jq.hasClass('show-outgoing') && this.$updateOutgoingLinks()).then(function () {
        jq.toggleClass('show-outgoing').removeClass('show-incoming');
      });
    },
    $getIncomingLinks: function $getIncomingLinks() {
      return getUsableLinks(this.getComplex(), this.getSlot());
    },
    $getOutgoingKnobs: function $getOutgoingKnobs() {
      return getUsableKnobs(this.getComplex(), this.getSlot());
    },

    /**
     * Updates the text values of the incoming links to this slot (will be shown
     * or hidden when the chevron at the left edge is clicked).
     *
     * @private
     * @returns {Promise} promise to be resolved when the incoming links'
     * text is updated and ready for display
     */
    $updateIncomingLinks: function $updateIncomingLinks() {
      var that = this,
          jq = that.jq(),
          incomingElement = that.$getIncomingLinksElement(),
          complex = that.getComplex(),
          links = that.$getIncomingLinks(),
          onlyLink = links[0],
          linksCount = links.length;
      jq.toggleClass('has-incoming', linksCount > 0);

      if (linksCount === 1) {
        return getComponentAndNavOrd(onlyLink.getSourceOrd()).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
              sourceComp = _ref4[0],
              ord = _ref4[1];

          sourceComp = sourceComp || complex;
          ord = ord || sourceComp.getNavOrd();
          var sourceSlot = onlyLink.getSourceSlotName();
          updateLinkText(incomingElement, sourceComp.getDisplayName(), sourceSlot, String(ord));
          incomingElement.data('links', toLinkTargets(links));
        });
      } else if (linksCount) {
        updateLinkText(incomingElement, webEditorsLex.get('multipleLinks'));
        incomingElement.data('links', toLinkTargets(links));
      } else {
        jq.removeClass('show-incoming');
      }
    },

    /**
     * Updates the text values of the outgoing knobs for this slot (will be
     * shown or hidden when the chevron at the right edge is clicked).
     *
     * @private
     * @returns {Promise} promise to be resolved when the outgoing links'
     * text is updated and ready for display
     */
    $updateOutgoingLinks: function $updateOutgoingLinks() {
      var that = this,
          jq = that.jq(),
          outgoingElement = that.$getOutgoingLinksElement(),
          complex = that.getComplex(),
          knobs = that.$getOutgoingKnobs(),
          onlyKnob = knobs[0],
          knobsCount = knobs.length;
      jq.toggleClass('has-outgoing', knobsCount > 0);

      if (knobsCount === 1) {
        return getComponentAndNavOrd(onlyKnob.getTargetOrd()).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
              targetComp = _ref6[0],
              ord = _ref6[1];

          targetComp = targetComp || complex;
          ord = ord || targetComp.getNavOrd();
          var targetSlot = onlyKnob.getTargetSlotName();
          updateLinkText(outgoingElement, targetComp.getDisplayName(), targetSlot, String(ord));
          outgoingElement.data('links', toLinkTargets(knobs));
        });
      } else if (knobsCount) {
        updateLinkText(outgoingElement, webEditorsLex.get('multipleLinks'));
        outgoingElement.data('links', toLinkTargets(knobs));
      } else {
        jq.removeClass('show-outgoing');
      }
    },

    /**
     * Pop up a link editor to edit the incoming links for this row.
     *
     * @private
     * @returns {Promise|undefined}
     */
    $editIncomingLinks: function $editIncomingLinks() {
      var complex = this.getComplex(),
          slot = this.getSlot(),
          links = complex.getLinks(slot);

      if (links.length === 1) {
        return LinkEditor.editLink({
          complex: complex,
          slot: links[0].getPropertyInParent(),
          properties: {
            editOutgoing: false,
            useHandles: true
          },
          readonly: !canEditLinks(complex)
        });
      }
    },

    /**
     * Pop up a link editor to edit the outgoing links for this row.
     *
     * @private
     * @returns {Promise|undefined}
     */
    $editOutgoingLinks: function $editOutgoingLinks() {
      var complex = this.getComplex(),
          slot = this.getSlot(),
          knobs = complex.getKnobs(slot),
          knob;

      if (knobs.length === 1) {
        knob = complex.getKnobs(slot)[0];
        return knob.getTargetOrd().get({
          base: baja.station,
          lease: true
        }).then(function (targetComp) {
          //TODO: what if multiple links to the target? ensure that we only
          //edit the link whose source ord/slot match our component/slot
          var link = targetComp.getLinks(knob.getTargetSlotName())[0],
              linkSlot = link.getPropertyInParent();
          return LinkEditor.editLink({
            complex: targetComp,
            slot: linkSlot,
            properties: {
              editIncoming: false,
              useHandles: true
            },
            readonly: !canEditLinks(complex)
          });
        });
      }
    },

    /**
     * Upon initializing the row, arm event handlers for showing/hiding/editing
     * the incoming/outgoing links. If the row has a mounted component loaded,
     * arm baja event handlers to keep the row up to date if Links or Knobs
     * are changed.
     *
     * @private
     * @param {JQuery} dom
     */
    $initializeLinks: function $initializeLinks(dom) {
      var that = this,
          complex = that.getComplex();
      dom.toggleClass('has-incoming', !!that.$getIncomingLinks().length);
      dom.toggleClass('has-outgoing', !!that.$getOutgoingKnobs().length);
      dom.on('mouseenter', '.col-display .incoming.links, .col-display.grabber', function () {
        that.$updateIncomingLinks();
      });
      dom.on('mouseenter', '.col-spacer .outgoing.links, .col-spacer .grabber', function () {
        that.$updateOutgoingLinks();
      });
      dom.on('click', '.col-display .incoming.links, .col-display .grabber', function () {
        that.$toggleIncomingLinks();
      });
      dom.on('click', '.col-spacer .outgoing.links, .col-spacer .grabber', function () {
        that.$toggleOutgoingLinks();
      });
      dom.on('click', '.links .display', function () {
        var links = $(this).closest('.links').data('links') || [];

        if (!links.length) {
          return;
        }

        toCommandGroup(links).then(function (group) {
          if (group.size() === 1) {
            return group.get(0).invoke();
          } else {
            return feDialogs.selfClosing({
              value: group,
              type: CommandButtonGroup
            });
          }
        })["catch"](logSevere);
        return false;
      });

      if (isMounted(complex)) {
        complex.attach('added changed removed', that.$linkListener = function (prop) {
          if (prop.getType().is('baja:Link')) {
            that.$updateIncomingLinks();
          }
        });
        complex.attach('addKnob removeKnob', that.$knobListener = function (slot) {
          that.$updateOutgoingLinks();
        });
      }
    },

    /**
     * When loading a value into the row, make sure the incoming/outgoing link
     * text is up to date.
     *
     * @private
     * @returns {Promise} promise to be resolved when all link text
     * has been updated
     */
    $updateLinks: function $updateLinks() {
      return Promise.all([this.$updateIncomingLinks(), this.$updateOutgoingLinks()]);
    },

    /**
     * When destroying the row, make sure we detach the baja event handlers
     * we attached in `$initializeLinks`.
     */
    $unsubscribeLinkEvents: function $unsubscribeLinkEvents() {
      var that = this,
          complex = that.getComplex(),
          knobListener = that.$knobListener,
          linkListener = that.$linkListener;

      if (knobListener) {
        complex.detach('addKnob removeKnob', knobListener);
      }

      if (linkListener) {
        complex.detach('added changed removed', linkListener);
      }
    }
  }; //TODO: should this return a new constructor like subscriberMixIn?

  var addLinkSupport = function addLinkSupport(target) {
    if (!applyMixin(target, MIXIN_NAME, exports)) {
      return;
    }

    var _doInitialize = target.doInitialize,
        _doDestroy = target.doDestroy;

    target.doInitialize = function (dom) {
      var that = this;
      return Promise.resolve(_doInitialize.apply(that, arguments)).then(function () {
        return that.$initializeLinks(dom);
      });
    };

    target.doDestroy = function () {
      var that = this;
      return Promise.resolve(_doDestroy.apply(that, arguments)).then(function () {
        return that.$unsubscribeLinkEvents();
      });
    };

    new Switchboard(target).allow('$updateIncomingLinks').oneAtATime().allow('$updateOutgoingLinks').oneAtATime();
  };

  return addLinkSupport;
});
