function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara: false */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/PropertySheetRowDragSupport
 */
define(['baja!', 'bajaux/dragdrop/dragDropUtils', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mixin/mixinUtils', 'css!nmodule/webEditors/rc/wb/mixin/PropertySheetRowDragSupport'], function (baja, dragDropUtils, Promise, _, feDialogs, compUtils, mixinUtils) {
  'use strict';

  var bulkAdd = compUtils.bulkAdd,
      fromClipboard = dragDropUtils.fromClipboard,
      applyMixin = mixinUtils.applyMixin,
      MIXIN_NAME = 'dragSupport';

  function isComponent(comp) {
    return baja.hasType(comp, 'baja:Component');
  }

  function isWb() {
    return typeof niagara !== 'undefined' && niagara.env.type === 'wb';
  }

  function canAddSlot(comp) {
    return isComponent(comp) && comp.getPermissions().hasAdminWrite();
  } //TODO: fix drag highlighting in Workbench (NCCB-9185)
  //purposely break styling in Workbench when dragging, since we never get the
  //dragleave event to remove the styling


  var DROP_TARGET_CLASS = isWb() ? 'wbDropTarget' : 'dropTarget';
  /**
   * Get the outermost property sheet DOM.
   *
   * @inner
   * @param {JQuery} dom
   * @returns {JQuery}
   */

  function getRootSheet(dom) {
    var result = dom.parents('.PropertySheet').last();
    return result.length ? result : dom;
  }
  /**
   * Remove all CSS visual drop cues by climbing up to the root property sheet
   * (if we are nested) and wiping all drag/drop associated CSS classes.
   *
   * @inner
   * @param {JQuery} dom
   */


  function clearAllDrops(dom) {
    getRootSheet(dom).find('.PropertySheetRow.drop').removeClass('above').removeClass('below').removeClass('drop');
  }
  /**
   * When applied to a `PropertySheetRow`, enable drag/drop onto that row to
   * allow adding slots directly to the `Component` loaded in that row.
   *
   * @private
   * @exports nmodule/webEditors/rc/wb/mixin/PropertySheetRowDragSupport
   * @mixin
   */


  var exports = {
    //TODO: confirm that this is proper behavior. Workbench allows drop even if readonly. see NCCB-6747

    /**
     * Return true if this row is a valid drop target.
     *
     * @private
     * @returns {Boolean}
     */
    $isDroppable: function $isDroppable() {
      return this.isEnabled() && !this.isReadonly() && canAddSlot(this.value());
    },

    /**
     * Return true if this row is ready to receive a drop event at this moment
     * (e.g. the user is currently dragged over the slot name).
     *
     * @private
     * @returns {*}
     */
    $canDropNow: function $canDropNow() {
      return this.jq().hasClass(DROP_TARGET_CLASS);
    },

    /**
     * Arm event handlers that will add a slot to the value loaded into this
     * row if valid data is dropped onto it.
     *
     * @private
     * @param {JQuery} dom
     */
    $initializeDrag: function $initializeDrag(dom) {
      var that = this;
      dom.on('dragleave dragend', function () {
        dom.removeClass(DROP_TARGET_CLASS);
      });
      dom.on('dragenter dragover', '.col-display .link', function (e) {
        if (that.$isDroppable()) {
          clearAllDrops(dom);
          dom.addClass(DROP_TARGET_CLASS);
          return false;
        }
      });
      dom.on('drop', '.col-display .link', function (e) {
        //TODO: multiple nodes
        if (that.$isDroppable()) {
          fromClipboard(e.originalEvent.dataTransfer).then(function (envelope) {
            return Promise.all([envelope.toJson(), envelope.toValues()]);
          }).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                json = _ref2[0],
                values = _ref2[1];

            return bulkAdd(that.value(), values, {
              names: _.map(json, 'name')
            });
          })["catch"](feDialogs.error)["finally"](function () {
            dom.removeClass(DROP_TARGET_CLASS);
          });
          return false;
        }
      });
    }
  };

  var addDragSupport = function addDragSupport(target) {
    if (!applyMixin(target, MIXIN_NAME, exports)) {
      return;
    }

    var _doInitialize = target.doInitialize;

    target.doInitialize = function (dom) {
      var that = this;
      return Promise.resolve(_doInitialize.apply(that, arguments)).then(function () {
        return that.$initializeDrag(dom);
      });
    };
  };

  return addDragSupport;
});
