/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/servlets/registry'], function (Promise, _, asyncUtils, registry) {
  'use strict';

  var doRequire = asyncUtils.doRequire,
      getEnabledMixinsOn = registry.getEnabledMixinsOn;
  /**
   * Get unique agent info objects based on the 'type' property.
   * @inner
   * @see {module:nmodule/webEditors/rc/servlets/registry.getTypeInfo}
   * @param {Array.<Object>} agentInfos
   * @returns {Array.<Object>}
   */

  function unique(agentInfos) {
    return _.uniq(agentInfos, _.property('type'));
  }

  function toTypeSpec(obj) {
    return obj.type;
  }
  /**
   * API Status: **Private**
   *
   * Functions for querying the registry about which manager columns to use for
   * particular Types.
   *
   * @exports nmodule/webEditors/rc/wb/mgr/model/mgrAgents
   */


  var mgrAgents = {};
  /**
   * @private
   * @param {Type|String} type
   * @returns {Promise.<Array.<{ getColumns: function}>>} promise to be resolved
   * with an array of manager agent modules (call `getColumns` on each)
   */

  mgrAgents.$getAgentsForMixinsOn = function (type) {
    return getEnabledMixinsOn(type).then(function (enabledTypeMixins) {
      return registry.getAgentOnInfo(enabledTypeMixins.map(toTypeSpec), {
        is: 'webEditors:IJavaScriptMgrAgent'
      }).then(function (agentInfos) {
        return unique(_.compact(_.flatten(agentInfos)));
      });
    }).then(function (mgrAgents) {
      return Promise.all(mgrAgents.map(function (mgrAgentInfo) {
        return doRequire(mgrAgentInfo.js.id, mgrAgentInfo.js.deps);
      }));
    });
  };
  /**
   * Query the registry for `IJavaScriptMgrAgent`s registered as mixins on the
   * given type, and resolve an array of all `MgrColumn`s to be added to a
   * manager.
   *
   * @param {Type|String} type
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn>>}
   */


  mgrAgents.getMixInColumns = function (type) {
    return mgrAgents.$getAgentsForMixinsOn(type).then(function (agentModules) {
      return _.flatten(_.invoke(agentModules, 'getColumns'));
    });
  };

  return mgrAgents;
});
