/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * @module nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn
 */
define(['nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn'], function (MgrColumn, IconColumn, TypeMgrColumn) {
  'use strict';
  /**
   * API Status: **Development**
   *
   * Subclass of the `IconColumn` type, for displaying an icon in a manager
   * table.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/columns/IconColumn
   */

  var IconMgrColumn = function IconMgrColumn(name, params) {
    IconColumn.apply(this, [name, params]);
  };

  IconMgrColumn.prototype = Object.create(IconColumn.prototype);
  IconMgrColumn.prototype.constructor = IconMgrColumn;
  MgrColumn.mixin(IconMgrColumn);
  /**
   * Build the dom for the cell. This overrides the buildCell() function
   * provided by MgrColumn to directly call the base class, which will
   * build a field editor for the icon.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   * @returns {Promise} A promise resolved with the img element added to the dom.
   */

  IconMgrColumn.prototype.buildCell = function (row, dom) {
    return IconColumn.prototype.buildCell.apply(this, arguments);
  };
  /**
   * Destroy the IconEditor that was created for this cell.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   * @returns {Promise}
   */


  IconMgrColumn.prototype.destroyCell = function (row, dom) {
    return IconColumn.prototype.destroyCell.apply(this, arguments);
  };
  /**
   * Get the icon for the row. If a type column has a new selected type
   * that has not been committed yet, this will return the icon for the
   * new type, assuming the row has an icon defined. If the row has no
   * icon, a new type's icon will not be considered.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {baja.Icon}
   */


  IconMgrColumn.prototype.getValueFor = function (row) {
    var icon = row.getIcon() && TypeMgrColumn.getIconForSelectedType(row);
    return icon || IconColumn.prototype.getValueFor.apply(this, arguments);
  };

  return IconMgrColumn;
});
