/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/MgrDuplicateCommand
 * @see module:nmodule/webEditors/rc/wb/commands/DuplicateCommand
 */
define(['underscore', 'nmodule/webEditors/rc/wb/commands/DuplicateCommand'], function (_, DuplicateCommand) {
  'use strict';

  function getSelection(manager) {
    return manager.getMainTable().$getSelection();
  } ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  /**
   * A command for duplicating slots in a Manager view.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/DuplicateCommand
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/MgrDuplicateCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager
   * @param {baja.Component} component
   */


  var MgrDuplicateCommand = function MgrDuplicateCommand(manager, component) {
    DuplicateCommand.call(this, component);
    var _invoke = this.invoke;

    this.invoke = function (params) {
      var inSlots = params && params.slots || [],
          rows = manager.getMainTable().getSelectedRows(),
          slots = _.map(rows, function (row) {
        return row.getSubject().getName();
      }).concat(inSlots);

      return _invoke.call(this, _.extend({}, params, {
        slots: slots
      })).then(function () {
        getSelection(manager).clear();
      });
    };
  };

  MgrDuplicateCommand.prototype = Object.create(DuplicateCommand.prototype);
  MgrDuplicateCommand.prototype.constructor = MgrDuplicateCommand;
  return MgrDuplicateCommand;
});
