/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/CancelDiscoverCommand
 */
define(['Promise', 'bajaux/commands/Command'], function (Promise, Command) {
  'use strict';
  /**
   * Command type for cancelling the discovery on a manager view.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/CancelDiscoverCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrLearn} manager
   */

  var CancelDiscoverCommand = function CancelDiscoverCommand(manager) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.mgr.cancel',
      enabled: false,

      /**
       * If the manager has a job associated with it, invoke the cancel action
       * on it.
       *
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/CancelDiscoverCommand#invoke
       *
       * @returns {Promise} the promise returned by the current Job's cancel action, or will
       * reject if there is no current job.
       */
      func: function func() {
        var job = manager.getJob();
        return job ? job.cancel() : Promise.reject(new Error('manager does not have a job'));
      }
    });
  };

  CancelDiscoverCommand.prototype = Object.create(Command.prototype);
  CancelDiscoverCommand.prototype.constructor = CancelDiscoverCommand;
  return CancelDiscoverCommand;
});
