function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/MgrSheet
 */
define(['lex!webEditors', 'log!nmodule.webEditors.rc.wb.mgr.MgrSheet', 'Promise', 'underscore', 'bajaux/Properties', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/mgr/model/MgrModelCompositeBuilder'], function (lexs, log, Promise, _, Properties, DisplayOnlyEditor, PropertySheet, MgrModelCompositeBuilder) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      webEditorsLex = _lexs[0];

  var logFine = log.fine.bind(log);
  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/MgrSheet
   * @extends module:nmodule/webEditors/rc/wb/PropertySheet
   * @param params
   */

  var MgrSheet = function MgrSheet(params) {
    var builder = params && params.data && params.data.builder;

    if (!(builder instanceof MgrModelCompositeBuilder)) {
      throw new Error('MgrModelCompositeBuilder required');
    }

    this.$baseBuilder = builder;
    PropertySheet.apply(this, arguments);
  };

  MgrSheet.prototype = Object.create(PropertySheet.prototype);
  MgrSheet.prototype.constructor = MgrSheet;
  /**
   * Decorates a `MgrModelCompositeBuilder` to be aware of the Property Sheet
   * in which it lives.
   *
   * In the `MgrModelCompositeBuilder`, each column in the `MgrModel` will
   * define field editors for that column by implementing `getConfigFor`. Here,
   * `MgrSheet` will put that field editor into one row of the Property Sheet.
   *
   * @returns {module:nmodule/webEditors/rc/wb/mgr/model/MgrModelCompositeBuilder}
   */

  MgrSheet.prototype.makeBuilder = function () {
    var that = this;
    var builder = this.$baseBuilder;
    var getConfigFor = builder.getConfigFor;

    builder.getDomFor = function (key) {
      return that.$buildSubEditorDom(key);
    };

    builder.getConfigFor = function (key) {
      return Promise.all([Promise["try"](function () {
        return getConfigFor.call(builder, key);
      })["catch"](function (err) {
        var msg = webEditorsLex.get({
          key: 'mgr.cannotEdit.message',
          args: [key]
        });
        logFine(msg, err);
        return {
          type: DisplayOnlyEditor
        };
      }), that.getOrdBase()]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            config = _ref2[0],
            ordBase = _ref2[1];

        var RowCtor = that.$getRowConstructor();
        return _.extend({}, config, {
          type: RowCtor,
          data: {
            builder: builder,
            key: key,
            displayWidget: config.type
          },
          properties: Properties.extend(that.properties(), {
            ordBase: ordBase,
            allowHyperlink: false
          }, config.properties).toObject()
        });
      });
    };

    return builder;
  };

  return MgrSheet;
});
