/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['nmodule/webEditors/rc/fe/registry/StationRegistry'], function (StationRegistry) {
  'use strict';

  var MENU_AGENT_TYPE = 'webEditors:IJavaScriptMenuAgent';

  function getReg() {
    return StationRegistry.getInstance();
  }
  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/wb/menu/menuAgents
   */


  var menuAgents = {};
  /**
   * Register a menu agent on a baja Type. A menu agent should be a function
   * that asynchronously resolves a CommandGroup appropriate for the widget's
   * loaded value.
   *
   * @param {Type|String} type
   * @param {String} module a RequireJS module ID that will resolve to a
   * menu agent function
   * @returns {Promise}
   */

  menuAgents.register = function (type, module) {
    return getReg().register(type, {
      rjs: module,
      tags: [MENU_AGENT_TYPE]
    });
  };
  /**
   * Given a nav node or baja value, resolve the appropriate menu agent for it.
   *
   * @param {baja.NavNode|baja.Value} value
   * @returns {Promise} promise to be resolved with a menu agent
   * function, or rejected if it could not be found
   */


  menuAgents.getAgentFor = function (value) {
    var t = typeof value.getNavTypeSpec === "function" ? value.getNavTypeSpec() : value.getType();
    return getReg().resolveFirst(t, {
      tags: [MENU_AGENT_TYPE]
    });
  };

  return menuAgents;
});
