function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*eslint-env browser */

/*jshint browser: true */

/*global niagara: false */
require.config({
  shim: {
    'nmodule/js/rc/jquery/contextMenu/jquery.contextMenu': {
      deps: ['jquery']
    },
    'nmodule/js/rc/jquery/contextMenu/jquery.ui.position': {
      deps: ['jquery']
    }
  }
});
/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
 */


define(['baja!', 'log!nmodule.webEditors.rc.wb.menu.CommandGroupContextMenu', 'bajaux/events', 'bajaux/Widget', 'bajaux/commands/Command', 'jquery', 'nmodule/js/rc/jquery/contextMenu/jquery.contextMenu', 'nmodule/js/rc/jquery/contextMenu/jquery.ui.position', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/menu/Separator', 'css!nmodule/js/rc/jquery/contextMenu/jquery.contextMenu'], function (baja, log, events, Widget, Command, $, $cm, $ui, Promise, _, fe, Separator) {
  'use strict';

  var DATA_KEY = 'contextMenuConfig',
      COMMAND_CHANGE_EVENT = events.command.CHANGE_EVENT,
      logSevere = log.severe.bind(log); ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////
  //TODO: can we stipulate that an editor add the contextMenu class to anything it wants right clickable? or let editor choose?

  /**
   * Get the CSS selector appropriate for the loaded editor.
   *
   * @inner
   * @param ed
   * @returns {string}
   */

  function getSelector(ed) {
    return ed.getContextMenuSelector ? ed.getContextMenuSelector() : '.contextMenu';
  } //TODO: just use pageX/pageY if Workbench ever supports it


  function getPageX(e) {
    if (e.touches && e.touches.length > 0) {
      return e.touches[0].pageX;
    } else {
      return e.pageX || e.clientX + $(window).scrollLeft();
    }
  }

  function getPageY(e) {
    if (e.touches && e.touches.length > 0) {
      return e.touches[0].pageY;
    } else {
      return e.pageY || e.clientY + $(window).scrollTop();
    }
  } //TODO: disable a second right click while toItems is working

  /**
   * Get the command from the items object with the specified key.
   *
   * @inner
   * @param {Object} items items object from `toItems()`
   * @param {String} key
   * @returns {module:bajaux/commands/Command}
   */


  function getCommand(items, key) {
    var result = items,
        keys = key.split('|').slice(0, -1);

    _.each(keys, function (key) {
      result = result[key].items;
    });

    return result[key].cmd;
  }

  var idCounter = 0;

  function generateIconHtml(cmd, elem) {
    var existing = Widget["in"](elem);
    return Promise.resolve(existing && existing.destroy()).then(function () {
      return fe.buildFor({
        value: baja.Icon.make([cmd.getIcon()]),
        dom: elem,
        formFactor: 'mini'
      });
    });
  }
  /**
   * Convert a command to an item object that `jQuery-contextMenu` can handle.
   *
   * @inner
   * @param {module:bajaux/commands/Command} cmd
   * @param {String} key the key string to be assigned to this command
   * @returns {Promise} promise to be resolved with the object literal
   */


  function commandToItem(cmd, key) {
    var div = $('<div/>'),
        iconId = 'CommandGroupContextMenu_Item_' + ++idCounter,
        safeToHideIcon = typeof cmd.safeToHideIcon !== 'function' || !!cmd.safeToHideIcon(),
        iconSpan = $('<span class="icon"/>').attr('id', iconId).toggleClass('safe-to-hide', safeToHideIcon).appendTo(div),
        displaySpan = $('<span class="display" />').appendTo(div);
    var isSeparator = cmd instanceof Separator;
    var separatorClass = isSeparator ? 'context-menu-divider' : '';
    cmd.on(COMMAND_CHANGE_EVENT, function () {
      var iconEl = $('#' + iconId);

      if (iconEl.length) {
        generateIconHtml(cmd, iconEl)["catch"](logSevere);
      }
    });
    return Promise.all([cmd.toDisplayName(), generateIconHtml(cmd, iconSpan)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          displayName = _ref2[0];

      displaySpan.text(displayName);
      var commandName = isSeparator ? '' : div.html(); //TODO: jQuery-contextMenu expects icons to use .icon-iconName CSS format. so should we

      return {
        cmd: cmd,
        className: separatorClass,
        key: key,
        disabled: !cmd.isEnabled(),
        hasForcedIcon: !safeToHideIcon,
        name: commandName,
        isHtmlName: true
      };
    });
  }
  /**
   * @inner
   * @param {*} item
   * @returns {boolean}
   */


  function isSeparator(item) {
    return !!(item.className && typeof item.className === 'string' && item.className.indexOf("context-menu-divider") > -1);
  }
  /**
   * @inner
   * @param {Array<*>} items
   */


  function removeStartingSeparator(items) {
    removeSeparatorAtIndex(items, 0);
  }
  /**
   * @inner
   * @param {Array<*>} items
   */


  function removeEndingSeparator(items) {
    removeSeparatorAtIndex(items, items.length - 1);
  }
  /**
   * @inner
   * @param {Array<*>} items
   * @param {int} index
   */


  function removeSeparatorAtIndex(items, index) {
    if (items.length > index && items.length > 0 && isSeparator(items[index])) {
      items.splice(index, 1);
    }
  }
  /**
   * @inner
   * @param {Array<*>} items
   */


  function removeConsecutiveSeparators(items) {
    var i = 0;

    while (i < items.length - 1) {
      if (isSeparator(items[i]) && isSeparator(items[i + 1])) {
        items.splice(i + 1, 1);
      } else {
        i++;
      }
    }
  }
  /**
   * @inner
   * @param {Array<*>} items
   */


  function coalesceSeparators(items) {
    removeStartingSeparator(items);
    removeEndingSeparator(items);
    removeConsecutiveSeparators(items);
  }
  /**
   * Convert a child `CommandGroup` to an object literal that
   * `jQuery-contextMenu` can handle, with child objects for child command
   * groups and commands.
   *
   * @inner
   * @param {module:bajaux/commands/CommandGroup} group
   * @param {String} key the string key to be assigned to this group
   * @returns {Promise} promise to be resolved with the object literal
   */


  function groupToItems(group, key) {
    return Promise.all(_.map(group.getChildren(), function (kid, i) {
      if (kid instanceof Command) {
        return commandToItem(kid, (key ? key + '|' : '') + 'cmd' + i);
      }

      return groupToItems(kid, (key ? key + '|' : '') + 'grp' + i);
    })).then(function (items) {
      coalesceSeparators(items);
      var itemsObj = {};

      _.each(items, function (item) {
        itemsObj[item.key] = item;
      });

      return group.toDisplayName().then(function (displayName) {
        return {
          name: displayName,
          isHtmlName: false,
          //NCCB-37763: keeping 'isHtmlName' false prevents XSS in the displayName
          disabled: !items.length,
          items: items.length && itemsObj,
          key: key
        };
      });
    });
  }
  /**
   * Convert the root command group to an object literal to be fed directly to
   * the `$.contextMenu` call.
   *
   * @inner
   * @param {module:bajaux/commands/CommandGroup} group the root group - direct
   * output from `$toContextMenu()`
   * @returns {Promise} promise to be resolve with an object literal
   * to be used as the `items` parameter to `$.contextMenu`
   */


  function rootToItems(group) {
    return groupToItems(group, '').then(_.property('items'));
  } ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * An add-on that enables right-click menus on editors with the
   * `contextMenuSupport` mixin. The context menu `CommandGroup` will be
   * shown using the `jQuery-contextMenu` library.
   *
   * If the editor does not have the `contextMenuSupport` mixin, you should
   * subclass `CommandGroupContextMenu` and implement `toContextMenu` yourself.
   *
   * Some themes will hide the icons from the menu for cleanliness. But this can
   * sometimes mean that they become unusable (for instance, a command to show
   * or hide a visible column uses a checkmark icon to show whether the column
   * is shown). To ensure the icon is always shown regardless of theme, have
   * the Command implement a function `safeToHideIcon()` that returns false.
   *
   * Similarly, you might want the context menu to remain open after invoking a
   * command again, I might want to show or hide multiple columns without having
   * to re-open the menu in between each). To enable this, have the Command
   * implement a `hideAfterInvoke()` function that returns false.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
   * @param {module:nmodule/webEditors/rc/fe/baja/BaseEditor} editor an editor
   * that in most cases should have the `contextMenuSupport` mixin added
   * @see module:nmodule/webEditors/rc/wb/mixin/ContextMenuSupport
   */


  var CommandGroupContextMenu = function CommandGroupContextMenu(editor) {
    if (!editor) {
      throw new Error('Editor required');
    }

    this.$ed = editor;
  };
  /**
   * Set up `jQuery-contextMenu` on this element, but bypass the built-in
   * event handling as we need to do some async work before menu shows up.
   * The `mousedown` handler we arm ourselves will do some async work, sock away
   * the data on the DOM element itself, and then manually trigger the
   * `contextMenu` call. `contextMenu` will then grab that data and use it
   * to build the menu on demand.
   *
   * @private
   * @param jq
   * @param selector
   */


  CommandGroupContextMenu.prototype.$armContextMenuAsync = function (jq, selector) {
    jq.contextMenu({
      selector: selector,
      trigger: 'none',
      reposition: false,
      build: function build($trigger) {
        var data = $trigger.data(DATA_KEY) || false;
        $trigger.removeData(DATA_KEY);
        return data;
      },
      $ref: this // hold onto this to reference in destroy()

    });
  };
  /**
   * Return a class name to apply to the menu root.
   *
   * @private
   * @param {object[]} items the config objects for each entry in the context menu
   * @returns {string}
   */


  CommandGroupContextMenu.prototype.$getClassName = function (items) {
    var className = 'hide-root-icons';

    if (_.any(_.pluck(items, 'hasForcedIcon'))) {
      //if any icons are forced to be shown, we can't use display: none to hide
      //other icons as this would break the layout. web/rc/theme/theme.css
      //caters for this.
      className += ' has-forced-icons';
    }

    return className;
  };
  /**
   * Asynchronously resolve the items to show in the context menu, then show it.
   *
   * @private
   * @param {jQuery.Event} e the right click event
   * @returns {boolean} false if the event needs to stop propagation
   */


  CommandGroupContextMenu.prototype.$doContextMenu = function (e) {
    var _this = this;

    var jq = this.$mjq = $(e.currentTarget);
    this.toItems(e).then(function (items) {
      if (!items) {
        return;
      }

      jq.data(DATA_KEY, {
        callback: function callback(key) {
          var command = getCommand(items, key);
          command.invoke()["catch"](logSevere);
          return typeof command.hideAfterInvoke !== 'function' || !!command.hideAfterInvoke();
        },
        className: _this.$getClassName(items),
        items: items
      });
      jq.contextMenu({
        //use 1 because if you wind up with 0, jQuery-contextMenu treats it as falsy
        x: getPageX(e) || 1,
        y: getPageY(e) || 1
      });
    })["catch"](logSevere);
    return false;
  };
  /**
   * Hides any currently shown context menu.
   * @private
   */


  CommandGroupContextMenu.prototype.$hideContextMenu = function () {
    var menuJq = this.$mjq;

    if (menuJq) {
      menuJq.contextMenu('hide');
    }
  };
  /**
   * Instantiates an items config object to be passed to the `$.contextMenu`
   * call. Config will be built up using the `CommandGroup` provided through
   * the `contextMenuSupport` mixin.
   *
   * @param {jQuery.Event} e the right-click event
   * @returns {Promise} promise to be resolved with an `items` config
   * object. See the `jQuery-contextMenu` documentation for details.
   */


  CommandGroupContextMenu.prototype.toItems = function (e) {
    return Promise.resolve(this.toContextMenu(e)).then(function (group) {
      return group && rootToItems(group);
    });
  };

  CommandGroupContextMenu.prototype.toContextMenu = function (e) {
    return this.$ed.$toContextMenu(e);
  };
  /**
   * JavaFX doesn't fire `contextmenu` events unless actually showing the Swing
   * context menu, which we disable (see BWebBrowser constructor). So fake it -
   * a right click will trigger `contextmenu` as expected. Only if WB/JavaFX
   * browser is detected.
   *
   * @param {JQuery} jq
   * @param {string} selector
   */


  CommandGroupContextMenu.shimContextMenuForWorkbench = function (jq, selector) {
    if (CommandGroupContextMenu.$isWorkbench() && CommandGroupContextMenu.$isJavaFX()) {
      jq.on('mousedown', selector, function (e) {
        if (e.which === 3) {
          $(e.target).trigger($.Event('contextmenu', {
            which: 3,
            originalEvent: e.originalEvent,
            data: e.data,
            pageX: e.pageX,
            pageY: e.pageY,
            offsetX: e.offsetX,
            offsetY: e.offsetY
          }));
        }
      });
    }
  };
  /**
   * @private
   * @returns {boolean}
   */


  CommandGroupContextMenu.$isWorkbench = function () {
    return typeof niagara !== 'undefined' && niagara.env.type === 'wb';
  };
  /**
   * @private
   * @returns {boolean}
   */


  CommandGroupContextMenu.$isJavaFX = function () {
    return !!navigator.userAgent.match(/JavaFX/);
  };
  /**
   * Arm event handlers on the loaded editor's DOM element to show the
   * context menu on right-click.
   *
   * @param {Object} [params]
   * @param {string} [params.selector='.contextMenu'] the selector from which to
   * delegate contextmenu events. If not given,
   * `editor.getContextMenuSelector()` will be called, if present; otherwise
   * default selector will be used.
   */


  CommandGroupContextMenu.prototype.arm = function (params) {
    var that = this,
        ed = that.$ed,
        selector = params && params.selector || getSelector(ed),
        jq = ed.jq();

    function doContextMenu(e) {
      return that.$doContextMenu(e);
    }

    CommandGroupContextMenu.shimContextMenuForWorkbench(jq, selector);

    if (ed.armContextMenu) {
      ed.armContextMenu(doContextMenu);
    } else {
      jq.on('contextmenu', selector, function (e) {
        if (e.which === 3) {
          return doContextMenu(e);
        }

        return false;
      });
    }

    that.$armContextMenuAsync(jq, selector);
  };
  /**
   * Destroy this context menu, releasing resources and event handlers.
   */


  CommandGroupContextMenu.prototype.destroy = function () {
    var _this2 = this;

    var jq = this.$ed.jq();

    if (!jq) {
      return;
    }

    this.$hideContextMenu(); //HAXX: so due to swisnl/jQuery-contextMenu #447, you can't destroy "just
    // one" menu because it matches against an un-matchable selector. so we're
    // going to hack in the selector so it matches against just one element: me.

    var menu = _.find($.contextMenu.menus, function (menu) {
      return menu.$ref === _this2;
    });

    if (menu) {
      menu.selector = jq;
      $.contextMenu('destroy', {
        context: jq
      });
      delete menu.$ref;
    }
  };
  /**
   * $.contextMenu is kind enough to expose its event handlers to us, so we
   * override layerClick which is the event when we click the transparent
   * fullscreen div shown when a context menu is open.
   *
   * The default implementation of it includes a bunch of
   * repositioning/retriggering logic that works great during normal use when
   * $.contextMenu is used synchronously, but since we have to defer displaying
   * the context menu until after we've had a chance to do network calls for
   * a menu agent, it falls apart for our use case.
   *
   * So we reimplement and simplify it. The only thing it will do now is listen
   * for a click and re-trigger it on the element that the user would have
   * clicked had the transparent div not been in the way.
   */


  $.contextMenu.handle.layerClick = function (e) {
    var root = $(this).data('contextMenuRoot'),
        $win = $(window),
        pageX = getPageX(e),
        pageY = getPageY(e),
        target,
        layerAteMouseup; // find the element that would've been clicked, wasn't the layer in the way

    if (document.elementFromPoint) {
      root.$layer.hide();
      target = document.elementFromPoint(pageX - $win.scrollLeft(), pageY - $win.scrollTop());
      root.$layer.show();
    }

    function clickName(which) {
      return which === 3 ? 'contextmenu' : 'click';
    }

    function retriggerOnTarget(name) {
      $(target).trigger($.Event(name, {
        which: e.which,
        pageX: pageX,
        pageY: pageY,
        shiftKey: e.shiftKey,
        ctrlKey: e.ctrlKey,
        originalEvent: e.originalEvent
      }));
    }

    var targetListener = function targetListener(e) {
      if (!layerAteMouseup) {
        retriggerOnTarget(clickName(e.which));
      }
    };

    root.$layer.one('mouseup', function (e) {
      layerAteMouseup = e.which || 1;
    });
    $(target).one('mouseup', targetListener);
    e.preventDefault();
    e.stopImmediatePropagation();

    if (target) {
      root.$trigger.one('contextmenu:hidden', function () {
        retriggerOnTarget('mousedown');

        if (layerAteMouseup) {
          $(target).off('mouseup', targetListener);
          retriggerOnTarget('mouseup');
          retriggerOnTarget(clickName(layerAteMouseup));
        }
      });
    }

    root.$menu.trigger('contextmenu:hide');
  };

  return CommandGroupContextMenu;
});
