/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/*eslint-env browser */

/*jshint browser: true */
define(['jquery'], function ($) {
  'use strict';
  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/wb/downloadUtils
   */

  var exports = {};

  exports.$getAnchor = function (fileContents, fileName, mimeType) {
    var blob = exports.$createBlob([fileContents], {
      type: mimeType
    });
    return {
      blob: blob,
      link: $("<a/>").attr('href', URL.createObjectURL(blob)).attr('download', fileName).attr('target', '_top')
    };
  };
  /**
   * Attempt to download the file with the given type, name, and contents in various browsers.
   *
   * @param {string} fileContents
   * @param {string} fileName
   * @param {string} mimeType
   */


  exports.download = function (fileContents, fileName, mimeType) {
    if (window.navigator && typeof window.navigator.msSaveBlob === 'function') {
      window.navigator.msSaveBlob(exports.$createBlob([fileContents]), fileName);
    } else {
      var linkAndBlob = exports.$getAnchor(fileContents, fileName, mimeType);
      var a = linkAndBlob.link;
      var blob = linkAndBlob.blob;
      downloadClick(a);
      URL.revokeObjectURL(blob);
    }
  };

  function downloadClick(a) {
    var clickEvent = window.document.createEvent("MouseEvent");
    clickEvent.initEvent("click", true, true);

    if (a.get(0)) {
      a.get(0).dispatchEvent(clickEvent);
    }
  }
  /**
   * Attempt to create a blob the normal way; fallback to BlobBuilder for Environments like PhantomJs.
   * @private
   * @param {Object} parts
   * @param {Object} [properties]
   * @returns {Blob}
   */


  exports.$createBlob = function (parts, properties) {
    parts = parts || [];
    properties = properties || {};

    try {
      return new Blob(parts, properties);
    } catch (e) {
      if (e.name !== "TypeError") {
        throw e;
      }

      var BlobBuilder = window.BlobBuilder || window.MSBlobBuilder || window.MozBlobBuilder || window.WebKitBlobBuilder;
      var builder = new BlobBuilder();

      for (var i = 0; i < parts.length; i++) {
        builder.append(parts[i]);
      }

      return builder.getBlob(properties.type);
    }
  };

  return exports;
});
