function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/composite/commands/AddCommand
 */
define(['baja!', 'baja!baja:CompositeAction,baja:CompositeTopic', 'jquery', 'lex!workbench', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/webEditors/rc/wb/table/model/Row'], function (baja, types, $, lexs, Promise, _, Command, Row) {
  'use strict';

  var IN = 0,
      OUT = 1,
      IN_ICON = baja.Icon.make('module://icons/x16/arrowLeft.png'),
      OUT_ICON = baja.Icon.make('module://icons/x16/arrowRight.png'),
      ACTION_TYPE = baja.lt('baja:CompositeAction'),
      TOPIC_TYPE = baja.lt('baja:CompositeTopic'),
      READONLY_FLAG = baja.Flags.READONLY,
      unescape = baja.SlotPath.unescape;

  function makeUniqueName(composite, model, name) {
    var slots = composite.getSlots().toArray(),
        rows = model.getRows(),
        tempName = name,
        count = 1;

    for (var i = 0; i < slots.length; i++) {
      if (slots[i].getName() === tempName) {
        tempName = name + count;
        count += 1;
        i = -1;
      } else {
        for (var j = 0; j < rows.length; j++) {
          var _rows$j$getSubject = rows[j].getSubject(),
              _name = _rows$j$getSubject.name;

          if (_name === tempName) {
            tempName = _name + count;
            count += 1;
            j = rows.length;
            i = -1;
          }
        }
      }
    }

    return tempName;
  }

  function makeTableRow(params) {
    var dir = params.dir,
        name = params.name,
        ord = params.ord,
        slot = params.slot,
        type = params.type,
        readonly = params.readonly,
        backup = params.backup,
        flags = params.flags,
        subject = {
      dir: dir,
      name: unescape(name),
      ord: ord,
      slot: slot,
      type: type,
      readonly: readonly,
      flags: flags
    };

    if (backup) {
      subject.backup = _.clone(subject);
    }

    return new Row(subject, dir === IN ? IN_ICON : OUT_ICON);
  }

  function handleAdd(editor) {
    var composite = editor.value(),
        tree = editor.$getTree(),
        table = editor.$getTable(),
        model = table.value(),
        nodes = tree.getSelectedNodes(),
        rows;
    rows = _(nodes).map(function (node) {
      var parent = node.getParent().value(),
          name = node.getName(),
          ord = parent.getSlotPath().toString(),
          slot = parent.getSlot(name),
          slotName = slot.getName(),
          rows = model.getRows(),
          flags = parent.getFlags(slot),
          inExists,
          outExists;

      _(rows).each(function (row) {
        var _row$getSubject = row.getSubject(),
            tempOrd = _row$getSubject.ord,
            tempSlot = _row$getSubject.slot,
            dir = _row$getSubject.dir;

        if (tempOrd + tempSlot === ord + slotName) {
          if (dir === OUT) {
            outExists = true;
          }

          if (dir === IN) {
            inExists = true;
          }
        }
      });

      if (inExists && outExists) {
        return null;
      } else {
        var readonly = slot.isTopic() || !!(flags & READONLY_FLAG);

        if (outExists && readonly) {
          return null;
        }

        var dir = readonly ? OUT : IN;
        dir = outExists ? IN : inExists ? OUT : dir;
        var type = slot.isTopic() ? TOPIC_TYPE : slot.isAction() ? dir === IN ? ACTION_TYPE : TOPIC_TYPE : node.value() ? node.value().getType() : parent.get(name).getType();
        return makeTableRow({
          dir: dir,
          ord: ord,
          type: type,
          readonly: readonly,
          name: makeUniqueName(composite, model, name),
          slot: slotName,
          backup: false,
          flags: baja.Flags.COMPOSITE
        });
      }
    });
    return model.insertRows(_.compact(rows));
  }
  /**
   * AddCommand
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/composite/commands/AddCommand
   */


  var AddCommand = /*#__PURE__*/function (_Command) {
    _inherits(AddCommand, _Command);

    var _super = _createSuper(AddCommand);

    function AddCommand(editor) {
      _classCallCheck(this, AddCommand);

      return _super.call(this, {
        module: "workbench",
        lex: 'compositeEditor.add',
        enabled: false,
        func: function func() {
          return handleAdd(editor);
        }
      });
    }

    _createClass(AddCommand, null, [{
      key: "$makeTableRow",
      value: function $makeTableRow(params) {
        return makeTableRow(params);
      }
    }]);

    return AddCommand;
  }(Command);

  return AddCommand;
});
