/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/multisheet/ShowActionsAndTopicsCommand
 */
define(['bajaux/commands/ToggleCommand'], function (ToggleCommand) {
  'use strict';
  /**
   * Command for toggling whether a MultiSheet is showing actions and topics.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/commands/multisheet/ShowActionsAndTopicsCommand
   * @extends module:bajaux/commands/ToggleCommand
   * @param {module:nmodule/webEditors/rc/wb/MultiSheet} multiSheet
   */

  var ShowActionsAndTopicsCommand = function ShowActionsAndTopicsCommand(multiSheet) {
    var that = this;
    ToggleCommand.call(that, {
      module: 'webEditors',
      lex: 'commands.showActionsAndTopics',
      selected: multiSheet.isShowActionsAndTopics(),
      func: function func() {
        that.toggle();
        return multiSheet.setShowActionsAndTopics(that.isSelected());
      }
    });
  };

  ShowActionsAndTopicsCommand.prototype = Object.create(ToggleCommand.prototype);
  ShowActionsAndTopicsCommand.prototype.constructor = ShowActionsAndTopicsCommand;
  return ShowActionsAndTopicsCommand;
});
