/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/SelectViewCommand
 */
define(['jquery', 'bajaux/commands/Command', 'dialogs', 'nmodule/js/rc/asyncUtils/asyncUtils', 'hbs!nmodule/webEditors/rc/wb/profile/agentListTemplate'], function ($, Command, dialogs, asyncUtils, agentListTemplate) {
  'use strict';

  var doRequire = asyncUtils.doRequire;
  /**
   * A command for selecting and loading a view.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/SelectViewCommand
   * @param {function} loadView A function that's called to load the selected view.
   */

  var SelectViewCommand = function SelectViewCommand(loadView) {
    var that = this;
    that.$loadView = loadView;
    Command.call(that, {
      module: 'webEditors',
      lex: 'commands.selectView',

      /**
       * Asks the user to select a view. Once selected, the view is loaded.
       *
       * @alias module:nmodule/webEditors/rc/wb/commands/SelectViewCommand#invoke
       */
      func: function func() {
        return that.toDisplayName().then(function (displayName) {
          return doRequire('profileInfo').then(function (profileInfo) {
            return that.$showDialog(displayName, profileInfo.getViewInfo());
          });
        });
      }
    });
  };

  SelectViewCommand.prototype = Object.create(Command.prototype);
  SelectViewCommand.prototype.constructor = SelectViewCommand;
  /**
   * Shows the view select dialog.
   *
   * @private
   *
   * @param {String} displayName The dialog's display name.
   * @param {Object} viewInfo The profile's current view information.
   * @returns {Promise} A promise that's resolved once the view has been selected
   * or the dialog has been canceled.
   */

  SelectViewCommand.prototype.$showDialog = function (displayName, viewInfo) {
    var that = this,
        html = '<div style="padding: 0.8em; display: flex; justify-content: center;">' + agentListTemplate(viewInfo) + '</div>';
    return dialogs.showOkCancel({
      title: displayName,
      content: function content(dlg, jq) {
        jq.html(html); // When a selection is made, automatically trigger 'ok'
        // to make the hyperlink.

        jq.on('change', function () {
          dlg.ok();
        });
      }
    }).ok(function (dlg) {
      var index = $("option:selected", dlg.jq()).index(),
          item = viewInfo.list[index];
      that.$loadView(item);
    }).promise();
  };

  return SelectViewCommand;
});
