/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/SaveBogFileCommand
 */
define(['bajaux/commands/Command'], function (Command) {
  'use strict';
  /**
   * A command for saving a BOG file.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/SaveBogFileCommand
   * @param navNode The Nav Node used to resolve the BOG space.
   * @throws {Error} if no `BaseEditor` provided
   */

  var SaveBogFileCommand = function SaveBogFileCommand(navNode) {
    var that = this;
    Command.call(that, {
      module: 'webEditors',
      lex: 'commands.saveBogFile',

      /**
       * Resolves the BOG space and saves it.
       *
       * @alias module:nmodule/webEditors/rc/wb/commands/SaveBogFileCommand#invoke
       */
      func: function func() {
        return navNode.getNavOrd().get().then(function (root) {
          return root.getComponentSpace().save();
        });
      }
    });
  };

  SaveBogFileCommand.prototype = Object.create(Command.prototype);
  SaveBogFileCommand.prototype.constructor = SaveBogFileCommand;
  return SaveBogFileCommand;
});
