function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/PopOutCommand
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.commands.PopOutCommand', 'bajaux/Properties', 'bajaux/commands/Command', 'bajaux/icon/iconUtils', 'bajaux/Widget', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/feUtils', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/wb/mixin/ProposalSupport'], function (baja, log, Properties, Command, iconUtils, Widget, $, Promise, _, switchboard, fe, feDialogs, feUtils, BaseEditor, addProposalSupport) {
  'use strict';

  var VALUE_READY_EVENT = BaseEditor.VALUE_READY_EVENT,
      hasMatchingConstructor = feUtils.hasMatchingConstructor,
      toHtml = iconUtils.toHtml,
      logError = log.severe.bind(log);

  function equivalent(value1, value2) {
    if (!baja.hasType(value1) || !baja.hasType(value2)) {
      return false;
    }

    return value1.equivalent(value2);
  }
  /**
   * Create a button for this widget constructor for the compact view selection
   * dialog.
   *
   * @inner
   * @param {Function} Ctor an editor constructor function
   * @returns {Promise} promise to be resolved with a button element
   */


  function toButton(Ctor) {
    //TODO: we are going to make the assumption that any editor i get here, i can instantiate with no params.
    var widget = new Ctor();
    return Promise.all([widget.toDisplayName(), widget.toDescription(), widget.toIcon().then(toHtml)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
          displayName = _ref2[0],
          description = _ref2[1],
          iconHtml = _ref2[2];

      var button = $('<button class="ux-btn widgetConstructor" title="' + description + '">' + '<span>' + displayName + '</span>' + '</button>').prepend(iconHtml);
      button.data('widgetConstructor', Ctor);
      return button;
    });
  }
  /**
   * A dialog to present a list of constructor functions in the form of buttons.
   * Clicking one will immediately resolve with that constructor function to
   * show in another dialog.
   *
   * @inner
   * @class
   */


  var CompactEditorSelectorDialog = function CompactEditorSelectorDialog() {
    BaseEditor.apply(this, arguments);
  };

  CompactEditorSelectorDialog.prototype = Object.create(BaseEditor.prototype);
  CompactEditorSelectorDialog.constructor = CompactEditorSelectorDialog;
  /**
   * Arm event handler to resolve with the constructor function when a button
   * is clicked. Adds "ButtonList" CSS class.
   *
   * @param {JQuery} dom
   */

  CompactEditorSelectorDialog.prototype.doInitialize = function (dom) {
    dom.addClass('ButtonList');
    dom.on('click', 'button', function () {
      var Ctor = $(this).data('widgetConstructor');
      dom.trigger(VALUE_READY_EVENT, [Ctor]);
    });
  };
  /**
   * Show a list of buttons for each editor constructor.
   *
   * @param {Array.<Function>} value an array of editor constructor functions
   * @returns {Promise} promise to be resolved when one button is shown
   * for each constructor
   */


  CompactEditorSelectorDialog.prototype.doLoad = function (value) {
    var dom = this.jq();
    return Promise.all(_.map(value, toButton)).then(function (buttons) {
      dom.html(buttons);
    });
  };
  /**
   * Removes "ButtonList" CSS class.
   *
   * @returns {Promise}
   */


  CompactEditorSelectorDialog.prototype.doDestroy = function () {
    var jq = this.jq();
    return Promise.resolve(BaseEditor.prototype.doDestroy.apply(this, arguments)).then(function () {
      jq.removeClass('ButtonList');
    });
  };
  /**
   * A command for showing a compact editor for another Editor's value,
   * allowing for editing the value in more detail.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/PopOutCommand
   * @param {module:bajaux/Widget} ed the
   * `Widget` to bind this `Command` to
   * @throws {Error} if no `Widget` provided
   */


  var PopOutCommand = function PopOutCommand(ed) {
    var that = this;

    that.$onLoaded = function () {
      that.$updateEnabled()["catch"](logError);
    };

    that.$onDestroyed = function () {
      delete that.$ed;
    };

    if (ed) {
      that.setWatchedEditor(ed);
    }

    Command.call(that, {
      module: 'webEditors',
      lex: 'commands.popOut',
      enabled: false,

      /**
       * Reads the watched `Widget`'s current value and pops up a
       * compact editor for more detailed editing. After the user enters a
       * value and submits, the entered value will be loaded back into the
       * watched `Widget`.
       *
       * @alias module:nmodule/webEditors/rc/wb/commands/PopOutCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        return PopOutCommand.$doPopOut(that.$ed);
      }
    }); //TODO: potential performance issue:

    /*
    in a property sheet row this gets hit a minimum of 3 times: creation,
    loading, and $updateCommandButtonGroup. consider a flag that says "i'll manage
    the enabled status myself," or minimize the times this gets hit.
     */

    switchboard(that, {
      $updateEnabled: {
        allow: 'oneAtATime',
        onRepeat: 'queue'
      }
    });
  };

  PopOutCommand.prototype = Object.create(Command.prototype);
  PopOutCommand.prototype.constructor = PopOutCommand;
  PopOutCommand.CompactEditorSelectorDialog = CompactEditorSelectorDialog;
  /**
   * Allows this Command to update its own enabled status based on the value
   * currently loaded in the watched `Widget`. If the value's Type has a
   * compact editor registered on it, the command will be enabled.
   *
   * @private
   * @returns {Promise}
   */

  PopOutCommand.prototype.$updateEnabled = function $updateEnabled(value) {
    var that = this,
        ed = that.$ed;

    if (value === undefined) {
      value = ed.value();
    }

    if (baja.hasType(value)) {
      return hasMatchingConstructor(value.getType(), {
        //use of facets is a bit of a niche case - if this editor is a child
        //editor of a ComplexCompositeEditor, it might have a uxFieldEditor
        //facet we want to respect.
        properties: ed.properties(),
        formFactor: 'compact'
      }).then(function (hasMatching) {
        return that.setEnabled(!ed.isReadonly() && ed.isEnabled() && hasMatching) || null; // squelch "promise not returned"
      });
    } else {
      return Promise.resolve(that.setEnabled(false));
    }
  };
  /**
   * @param {module:bajaux/Widget} ed
   */


  PopOutCommand.prototype.setWatchedEditor = function (ed) {
    if (!(ed instanceof Widget)) {
      throw new Error('Widget required');
    }

    this.$ed = ed;
    addProposalSupport(ed);
    ed.on('loaded', this.$onLoaded);
    ed.on('destroyed', this.$onDestroyed);
    this.$updateEnabled(ed.value())["catch"](logError);
  };
  /**
   * @param {module:bajaux/Widget} ed
   * @return {Promise}
   * @private
   */


  PopOutCommand.$doPopOut = function (ed) {
    var props = ed.properties();
    var oldValue;
    return ed.read().then(function (value) {
      oldValue = value;
      return Promise.all([fe.getConstructors(value.getType(), {
        properties: props,
        formFactor: 'compact'
      }), _.result(ed, "getOrdBase")]);
    }).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          ctors = _ref4[0],
          ordBase = _ref4[1];

      function show(Ctor) {
        if (!Ctor) {
          return null;
        }

        return feDialogs.showFor({
          value: oldValue,
          complex: _.result(ed, 'getComplex'),
          slot: _.result(ed, 'getSlot'),
          type: Ctor,
          properties: Properties.extend(props, {
            ordBase: ordBase
          }),
          formFactor: 'compact',
          save: false
        });
      }

      if (ctors.length > 1) {
        return feDialogs.selfClosing({
          type: CompactEditorSelectorDialog,
          value: ctors,
          formFactor: 'compact'
        }).then(show);
      } else {
        return show(ctors[0]);
      }
    }).then(function (newValue) {
      if (newValue !== null && !equivalent(newValue, oldValue)) {
        return ed.propose(newValue);
      }
    });
  };

  return PopOutCommand;
});
