/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/LinkToCommand
 */
define(['baja!', 'Promise', 'nmodule/webEditors/rc/wb/commands/LinkCommand'], function (baja, Promise, LinkCommand) {
  'use strict'; ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/LinkCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/LinkToCommand
   * @param {baja.Component} component - the link target component
   * @throws {Error} if no `Widget` provided
   */

  var LinkToCommand = function LinkToCommand(component) {
    LinkCommand.call(this, component, 'commands.linkTo');
  };

  LinkToCommand.prototype = Object.create(LinkCommand.prototype);
  LinkToCommand.prototype.constructor = LinkToCommand;
  /**
   * Returns an object with source and target components populated,
   * given the specified component.
   *
   * The component is the target and the marked link is the source
   *
   * @param {baja.Component} component - the target component.
   * @return {Promise} that resolves to an `Object`
   */

  LinkToCommand.prototype.getSourceTarget = function (component) {
    return this.getLinkMark().then(function (navNodes) {
      // TODO Handle multiple LinkMark and Components
      return navNodes[0].getNavOrd().get({
        lease: true
      }).then(function (linkMark) {
        return {
          targets: [linkMark],
          sources: [component]
        };
      });
    });
  };
  /**
   * Make a LinkToCommand and initialize it.
   *
   * @param component
   * @returns {Promise.<LinkFromCommand>} promise that resolves to a LinkFromCommand after the
   * command has been initialized.
   */


  LinkToCommand.make = function (component) {
    var cmd = new LinkToCommand(component);
    return cmd.init(component).then(function () {
      return cmd;
    });
  };

  return LinkToCommand;
});
