/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/LinkMarkCommand
 */
define(['nmodule/webEditors/rc/wb/util/TransferDataManager', 'nmodule/webEditors/rc/wb/commands/ComponentEditorCommand'], function (TransferDataManager, ComponentEditorCommand) {
  'use strict';

  var transferDataManager = TransferDataManager.getInstance(); ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/ComponentEditorCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/LinkMarkCommand
   * @param {baja.Component} component the component to mark for linking
   * @throws {Error} if no `Widget` provided
   */

  var LinkMarkCommand = function LinkMarkCommand(component) {
    var that = this;
    ComponentEditorCommand.call(that, {
      module: 'webEditors',
      lex: 'commands.linkMark'
    }, component);
  };

  LinkMarkCommand.prototype = Object.create(ComponentEditorCommand.prototype);
  LinkMarkCommand.prototype.constructor = LinkMarkCommand;
  /**
   * Make sure can link from this component.
   *
   * @param {baja.Component} component
   * @param {baja.Slot} slot
   * @returns {Boolean} true if I can link from this component.
   */

  LinkMarkCommand.prototype.canPerformCommand = function (component, slot) {
    // TODO Maybe check to see if component is a NavNode?
    return true;
  };
  /**
   * Link From this component
   *
   * Display the dialog that allows the user to choose which slots to link.
   *
   * @param {baja.Component} component
   * @param {Array.<baja.Slot>} slots, optional (may be `null` or an empty array)
   * @param {Object} params
   * @returns {Promise} promise to be resolved after the command has executed
   */


  LinkMarkCommand.prototype.performCommand = function (component, slots, params) {
    if (slots) {
      return transferDataManager.setLinkMark(slots.map(function (slot) {
        return component.get(slot, {
          lease: true
        });
      }));
    }

    return transferDataManager.setLinkMark([component]);
  };
  /**
   * Make a LinkMarkCommand and initialize it.
   *
   * @param {baja.Component} component
   * @returns {module:nmodule/webEditors/rc/wb/commands/LinkMarkCommand}
   */


  LinkMarkCommand.make = function (component) {
    var cmd = new LinkMarkCommand(component);
    cmd.setEnabled(true);
    return cmd;
  };

  return LinkMarkCommand;
});
