/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/DatePickerPopupCommand
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.commands.DatePickerPopupCommand', 'bajaux/commands/Command', 'dialogs', 'Promise', 'nmodule/webEditors/rc/fe/baja/compat/PikadayDateEditor'], function (baja, log, Command, dialogs, Promise, PikadayDateEditor) {
  'use strict';

  var logError = log.severe.bind(log);
  /**
   * Command to show a date picker in a popup. `invoke()` will resolve with
   * a `Date` instance, or `null` if the user clicks Cancel.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/DatePickerPopupCommand
   */

  var DatePickerPopupCommand = function DatePickerPopupCommand() {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.datePicker',
      func: function func(params) {
        return DatePickerPopupCommand.doDialog(params);
      }
    });
  };

  DatePickerPopupCommand.prototype = Object.create(Command.prototype);
  DatePickerPopupCommand.prototype.constructor = DatePickerPopupCommand;
  /**
   * @param {Object} [params]
   * @param {Date} [params.defaultDate] the default date to select on popup
   * @returns {Promise.<Date>}
   */

  DatePickerPopupCommand.doDialog = function (params) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve) {
      dialogs.showCancel({
        content: function content(dialog, dom) {
          var picker = new PikadayDateEditor({
            properties: {
              embedded: true,
              onSelect: function onSelect(editor) {
                return editor.read().then(function (value) {
                  dialog.close();
                  resolve(value.getJsDate());
                })["catch"](logError);
              }
            }
          }),
              defaultDate = params && params.defaultDate;
          return picker.initialize(dom).then(function () {
            return defaultDate && picker.load(baja.Date.make({
              jsDate: defaultDate
            }));
          });
        },
        cancel: function cancel() {
          resolve(null);
        }
      });
    });
  };

  return DatePickerPopupCommand;
});
