/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaScript/baja/comp/LinkCheck', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/baja/clientLinkCheck'], function (baja, LinkCheck, Promise, _, clientLinkCheck) {
  'use strict';

  var linkCheckUtil = {};
  /**
   * Perform client-side link checking (and optionally follow up with a server side link check)
   *
   * @param {Object} ref
   * @param {Component} [ref.source]
   * @param {Slot}      [ref.sourceSlot]
   * @param {Component} [ref.target]
   * @param {Slot}      [ref.targetSlot]
   *
   * @param {Boolean}   checkServer - true if the server check link should also be performed.
   * If server check is performed, the client LinkCheck will have a new Promise on attribute
   * LinkCheck.serverLinkCheck.  This secondary Promise<LinkCheck> is the result
   * of calling ref.targetComponent.checkLink().
   *
   * @returns {Promise.<LinkCheck>} resolves to a LinkCheck
   */

  linkCheckUtil.checkLink = function checkLink(ref, checkServer) {
    var target = ref.target;

    if (checkServer) {
      var serverLinkCheck = target.checkLink(ref);
      return clientLinkCheck(ref).then(function (linkCheck) {
        if (linkCheck) {
          linkCheck.serverLinkCheck = serverLinkCheck;
        } else {
          linkCheck = new LinkCheck(false, 'Cannot determine validity.');
          linkCheck.serverLinkCheck = serverLinkCheck;
        }

        return linkCheck;
      });
    } else {
      return clientLinkCheck.apply(this, arguments);
    }
  };

  return linkCheckUtil;
});
