function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/MultiSheet
 */
define(['baja!', 'lex!baja', 'bajaux/Widget', 'bajaux/commands/CommandGroup', 'bajaux/events', 'bajaux/util/CommandButtonGroup', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/util/slotUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/util/ListSelection', 'nmodule/webEditors/rc/wb/MultiSheetRow', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/commands/multisheet/ShowActionsAndTopicsCommand', 'nmodule/webEditors/rc/wb/commands/multisheet/ShowHiddenSlotsCommand', 'nmodule/webEditors/rc/wb/commands/multisheet/ToggleSlotModeCommand', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/mixin/MultiSheetCommands', 'nmodule/webEditors/rc/wb/mixin/PropertySheetDragSupport', 'nmodule/webEditors/rc/wb/mixin/TransferSupport'], function (baja, lexs, Widget, CommandGroup, events, CommandButtonGroup, $, Promise, _, fe, slotUtils, typeUtils, htmlUtils, ListSelection, MultiSheetRow, PropertySheet, ShowActionsAndTopicsCommand, ShowHiddenSlotsCommand, ToggleSlotModeCommand, addContextMenuSupport, addMultiSheetCommands, addDragSupport, addTransferSupport) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      bajaLex = _lexs[0];

  var INVOKE_EVENT = events.INVOKE_EVENT;
  var preventSelectOnShiftClick = htmlUtils.preventSelectOnShiftClick;
  var isUiVisible = slotUtils.isUiVisible;
  var isComplex = typeUtils.isComplex;
  var SLOT_MODE_CLASS = 'slotmode';

  function getDisplayName(comp) {
    return comp.getDisplayName() || bajaLex.get('nav.station');
  }

  function toGetter(val) {
    return function () {
      return val;
    };
  } ////////////////////////////////////////////////////////////////
  // MultiSheet
  ////////////////////////////////////////////////////////////////

  /**
   * A `MultiSheet` is an extension of a `PropertySheet` that adds additional
   * functionality through the use of mixins.
   *
   * This allows the `PropertySheet` to be a more limited, lighter-weight
   * editor for cases like editing components in dialogs. The `MultiSheet`
   * makes for a more fully-featured, detailed view.
   *
   * Functionality added on top of `PropertySheet` includes:
   *
   * - Drag/drop support
   * - Incoming/outgoing link support
   * - Toggle hidden slots / actions and topics / slot structure details
   * - Add/delete/rename/flags/facets Commands
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/PropertySheet
   * @alias module:nmodule/webEditors/rc/wb/MultiSheet
   * @param {Object} [params]
   * @mixes module:nmodule/webEditors/rc/wb/mixin/PropertySheetDragSupport
   */


  var MultiSheet = function MultiSheet(params) {
    var that = this;
    PropertySheet.call(that, $.extend(true, {
      keyName: 'MultiSheet',
      properties: {
        showHiddenSlots: {
          value: false,
          hidden: true
        },
        showActionsAndTopics: {
          value: false,
          hidden: true
        },
        slotMode: {
          value: false,
          hidden: true
        },
        showControls: true
      }
    }, params));
    addDragSupport(that);
    addMultiSheetCommands(that);
    addTransferSupport(that);

    if (!that.properties().getValue('nested')) {
      addContextMenuSupport(that);
    }

    that.$getShowHiddenSlotsCommand = toGetter(new ShowHiddenSlotsCommand(that));
    that.$getShowActionsAndTopicsCommand = toGetter(new ShowActionsAndTopicsCommand(that));
    that.$getToggleSlotModeCommand = toGetter(new ToggleSlotModeCommand(that));
    var selection = that.$selection = new ListSelection();
    selection.on('changed', function () {
      _.each(that.$getKidRows(), function (kid, i) {
        kid.$setSelected(selection.isSelected(i));
      });
    });
  };

  MultiSheet.prototype = Object.create(PropertySheet.prototype);
  MultiSheet.prototype.constructor = MultiSheet;
  /**
   * Get the fixed header div containing the multisheet controls.
   *
   * @private
   * @returns {jQuery}
   */

  MultiSheet.prototype.$getControlsElement = function () {
    return this.jq().children('.PropertySheet-controls');
  };
  /**
   * Get the element containing the slot details toggle commands.
   *
   * @private
   * @returns {jQuery}
   */


  MultiSheet.prototype.$getCommandsElement = function () {
    return this.$getControlsElement().children('.commands');
  };
  /**
   * Get the CommandButtonGroup containing the slot details toggle commands.
   *
   * @private
   * @returns {module:bajaux/util/CommandButtonGroup}
   */


  MultiSheet.prototype.$getControlsCommandButtonGroup = function () {
    return this.$getCommandsElement().data('widget');
  };
  /**
   * Get the element containing the display name (should show the display name
   * of the currently loaded component).
   *
   * @private
   * @returns {jQuery}
   */


  MultiSheet.prototype.$getDisplayNameElement = function () {
    return this.$getControlsElement().children('.displayName');
  };
  /**
   * Each row instantiated will receive mixins to allow drag/drop and link
   * support.
   *
   * @private
   * @returns {Function}
   */


  MultiSheet.prototype.$getRowConstructor = function () {
    return MultiSheetRow;
  };
  /**
   * Return true if the slot should be shown. Hidden slots will be shown if
   * the multisheet is currently set to show hidden slots - same for actions
   * and topics.
   *
   * Overrides `$shouldShowSlot` on `PropertySheet`.
   *
   * @private
   * @param {baja.Slot} slot
   * @returns {Boolean}
   */


  MultiSheet.prototype.$shouldShowSlot = function (slot) {
    var showHidden = this.isShowHiddenSlots(),
        showActionsAndTopics = this.isShowActionsAndTopics();

    if (!showHidden && !isUiVisible(slot)) {
      return false;
    }

    if (!showActionsAndTopics && !slot.isProperty()) {
      return false;
    }

    return true;
  };
  /**
   * Get configuration for slots to be shown.
   *
   * @returns {Function}
   */


  MultiSheet.prototype.getSlotFilter = function () {
    var that = this,
        filter = PropertySheet.prototype.getSlotFilter.apply(that, arguments);
    return function (slot) {
      var slotConfig = filter(slot); //this will be a HideMeWidget if the PropertySheet thinks we shouldn't
      //show it. override it if we're showing hidden slots.
      //come back and remove this after reworking the whole HideMeWidget mechanism

      if (that.isShowHiddenSlots()) {
        slotConfig.type = that.$getRowConstructor();
      }

      return slotConfig;
    };
  };
  /**
   * Return true if actions and topics should currently be shown.
   *
   * @returns {Boolean}
   */


  MultiSheet.prototype.isShowActionsAndTopics = function () {
    return !!this.properties().getValue('showActionsAndTopics');
  };
  /**
   * Set whether actions and topics should currently be shown.
   *
   * @param {Boolean} showActionsAndTopics
   * @returns {Promise} promise to be resolved after action and topic
   * slots are torn down or rebuilt
   */


  MultiSheet.prototype.setShowActionsAndTopics = function (showActionsAndTopics) {
    if (showActionsAndTopics === this.isShowActionsAndTopics()) {
      return Promise.resolve();
    }

    this.properties().setValue('showActionsAndTopics', !!showActionsAndTopics);
    return this.$filterChanged();
  };
  /**
   * Return true if slot structure details are currently shown.
   *
   * @returns {Boolean}
   */


  MultiSheet.prototype.isSlotMode = function () {
    return !!this.properties().getValue('slotMode');
  };
  /**
   * Set whether slot structure details should currently be shown. (This does
   * not return a promise - since we're not changing what slots are shown,
   * we have nothing to rebuild. This is purely a visual/styling change.)
   *
   * @param {Boolean} slotMode
   */


  MultiSheet.prototype.setSlotMode = function (slotMode) {
    var that = this,
        showHiddenSlotsCmd = that.$getShowHiddenSlotsCommand();

    if (slotMode === that.isSlotMode()) {
      return;
    }

    that.properties().add('slotMode', !!slotMode);
    that.jq().toggleClass(SLOT_MODE_CLASS, !!slotMode);
    showHiddenSlotsCmd.$updateEnabled();

    if (!slotMode) {
      that.$selection.clear();
      that.setShowHiddenSlots(false);
      showHiddenSlotsCmd.setSelected(false);
    }

    _.each(that.$getKidRows(), function (row) {
      row.$setSelected(false);
      row.properties().add('slotMode', !!slotMode);
    });

    _.each(that.$getExpandedPropertySheets(), function (sheet) {
      sheet.setSlotMode(slotMode);
    });
  };
  /**
   * Propagate changes to the `showActionsAndTopics` and `showHiddenSlots`
   * Properties down to child rows.
   */


  MultiSheet.prototype.doChanged = function (name, value) {
    if (name === 'showActionsAndTopics' || name === 'showHiddenSlots') {
      _.each(this.$getKidRows(), function (row) {
        row.properties().setValue(name, value);
      });
    }
  };

  MultiSheet.prototype.getSubject = function (jq) {
    var value = null;
    var rowJq = jq.closest('.PropertySheetRow');

    if (rowJq.length) {
      var row = Widget["in"](jq.closest('.col-display').parent());

      if (row && row === Widget["in"](rowJq)) {
        value = row.value();
      }
    } else {
      var sheet = Widget["in"](jq.closest('.PropertySheet'));

      if (sheet) {
        value = sheet.value();
      }
    }

    return isComplex(value) ? [value] : null;
  };
  /**
   * Instantiate a CommandButtonGroup for the slot structure toggle commands.
   *
   * Arm event handlers to keep MultiSheet Commands' enabled status up to date,
   * and allow selection of multiple child rows.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */


  MultiSheet.prototype.doInitialize = function (dom) {
    var that = this,
        selection = that.$selection;
    preventSelectOnShiftClick(dom);
    return Promise.resolve(PropertySheet.prototype.doInitialize.apply(that, arguments)).then(function () {
      dom.on('PropertySheetRow:selected PropertySheetRow:deselected', baja.throttle(function () {
        that.$updateCommands();
      }, 100));
      dom.on(INVOKE_EVENT, function () {
        that.$updateCommands();
      });
      dom.on('click', '.PropertySheet-table-container', function (e) {
        if (that.isSlotMode() && that.properties().getValue('allowSelection') !== false) {
          var tableRow = $(e.target).closest('tr.PropertySheetRow').data('widget'),
              rows = that.$getKidRows(),
              idx = rows.indexOf(tableRow);
          selection[e.shiftKey ? 'swath' : e.ctrlKey ? 'toggle' : 'select'](idx);
          return false;
        }
      });
      dom.toggleClass(SLOT_MODE_CLASS, that.isSlotMode());
      return fe.buildFor({
        dom: that.$getCommandsElement(),
        value: new CommandGroup({
          displayName: 'config',
          commands: [that.$getShowHiddenSlotsCommand(), that.$getShowActionsAndTopicsCommand(), that.$getToggleSlotModeCommand()]
        }),
        type: CommandButtonGroup,
        properties: {
          toolbar: true,
          onDisabled: 'hide'
        }
      });
    });
  };
  /**
   * Update the display name element with the loaded component's display name.
   *
   * @param {baja.Complex} comp
   * @returns {Promise}
   */


  MultiSheet.prototype.doLoad = function (comp) {
    var that = this;
    return Promise.resolve(PropertySheet.prototype.doLoad.apply(that, arguments)).then(function () {
      that.$getDisplayNameElement().text(getDisplayName(comp));
    });
  };
  /**
   * Sets slot mode to false and disables slot mode command.
   *
   * @param {Boolean} modified
   */


  MultiSheet.prototype.doModified = function (modified) {
    this.setSlotMode(false);
  };
  /**
   * Destroy the CommandButtonGroup for the MultiSheet Commands.
   *
   * @returns {Promise}
   */


  MultiSheet.prototype.doDestroy = function () {
    var that = this;
    return Promise.resolve(PropertySheet.prototype.doDestroy.apply(that, arguments)).then(function () {
      that.jq().removeClass(SLOT_MODE_CLASS);
      return that.$getControlsCommandButtonGroup().destroy();
    });
  };

  return MultiSheet;
});
