function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/*eslint-env browser */

/*jshint browser: true */
define(['baja!', 'dialogs', 'lex!webEditors', 'jquery'], function (baja, dialogs, lexes, $) {
  'use strict';

  var _lexes = _slicedToArray(lexes, 1),
      webEditorsLex = _lexes[0];
  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/util/fileUtils
   */


  var exports = {};
  /**
   * @private
   */

  exports.$getDownloadConfig = function (fileContents, fileName, mimeType) {
    var blob = exports.$createBlob([fileContents], {
      type: mimeType
    });
    return {
      blob: blob,
      link: exports.$getAnchor(URL.createObjectURL(blob), fileName)
    };
  };
  /**
   * @private
   */


  exports.$getAnchor = function (link, fileName) {
    return $("<a/>").attr('href', link).attr('download', fileName).attr('target', '_top');
  };
  /**
   * Attempt to download the file with the given type, name, and contents in various browsers.
   *
   * @param {string} fileContents
   * @param {string} fileName
   * @param {string} mimeType
   */


  exports.download = function (fileContents, fileName, mimeType) {
    if (window.navigator && typeof window.navigator.msSaveBlob === 'function') {
      window.navigator.msSaveBlob(exports.$createBlob([fileContents]), fileName);
    } else {
      var _exports$$getDownload = exports.$getDownloadConfig(fileContents, fileName, mimeType),
          link = _exports$$getDownload.link,
          blob = _exports$$getDownload.blob;

      downloadClick(link);
      URL.revokeObjectURL(blob);
    }
  };
  /**
   * @param {string} url - Direct download url
   * @param {string} fileName
   */


  exports.directDownload = function (url, fileName) {
    var link = exports.$getAnchor(url, fileName);
    downloadClick(link);
  };

  function downloadClick(a) {
    var clickEvent = window.document.createEvent("MouseEvent");
    clickEvent.initEvent("click", true, true);

    if (a.get(0)) {
      a.get(0).dispatchEvent(clickEvent);
    }
  }
  /**
   * Attempt to create a blob the normal way; fallback to BlobBuilder for Environments like PhantomJs.
   * @private
   * @param {Object} parts
   * @param {Object} [properties]
   * @returns {Blob}
   */


  exports.$createBlob = function (parts, properties) {
    parts = parts || [];
    properties = properties || {};

    try {
      return new Blob(parts, properties);
    } catch (e) {
      if (e.name !== "TypeError") {
        throw e;
      }

      var BlobBuilder = window.BlobBuilder || window.MSBlobBuilder || window.MozBlobBuilder || window.WebKitBlobBuilder;
      var builder = new BlobBuilder();

      for (var i = 0; i < parts.length; i++) {
        builder.append(parts[i]);
      }

      return builder.getBlob(properties.type);
    }
  };
  /**
   * Determines whether the file with the given ord exists on the station or not.
   * @param {String|baja.Ord} ord
   * @returns {Promise.<boolean>}
   */


  exports.exists = function (ord) {
    return baja.rpc({
      typeSpec: 'web:FileRpc',
      method: 'exists',
      args: [String(ord)]
    })["catch"](function (ignore) {
      return false;
    });
  };
  /**
   * Determines whether or not we are allowed to write to the given file on the
   * server. If the file does not exist or the user indicates they want to
   * overwrite the file, resolves true. Otherwise resolves false.
   *
   * @param {String} ord the ord pointing to the desired write location
   * @returns {Promise.<boolean>} resolves true if OK with the user to write to
   * this file.
   */


  exports.confirmServerFileWrite = function (ord) {
    return exports.exists(ord).then(function (fileExists) {
      // TODO: Distinguish between recoverable (user clicked no) and unrecoverable errors
      return !fileExists || exports.$userConfirmsOverwrite();
    });
  };
  /**
   * @private
   * @returns {Promise<boolean>} resolves to true if the user clicks yes
   * to the "overwrite?" dialog
   */


  exports.$userConfirmsOverwrite = function () {
    var result;
    return dialogs.showYesNo({
      title: webEditorsLex.get("export.duplicateFile.title"),
      content: webEditorsLex.getSafe("export.duplicateFile.content"),
      yes: function yes() {
        result = true;
      },
      no: function no() {
        result = false;
      }
    }).promise().then(function () {
      return result;
    });
  };
  /**
   * @param {String} ord file ORD to write to
   * @returns {Promise.<boolean>} to be resolved with true, if the user has
   * permissions to write this file
   */


  exports.isWritable = function (ord) {
    return baja.rpc({
      typeSpec: 'web:FileRpc',
      method: 'isWritable',
      args: [ord]
    });
  };

  return exports;
});
