/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @since Niagara 4.6
 * @module nmodule/webEditors/rc/util/decorate
 */
define(['Promise', 'underscore', 'baja!', 'nmodule/webEditors/rc/fe/registry/StationRegistry'], function (Promise, _, baja, StationRegistry) {
  'use strict';
  /**
   * Used to asynchronously add new behavior to an existing object.
   *
   * This method is typically invoked during a widget's initialization phase. Any registered
   * agents on the target type can then decorate the widget accordingly.
   *
   * @alias module:nmodule/webEditors/rc/util/decorate
   *
   * @param  {Object} object The object to decorate. This object will be passed to the decorator to be decorated.
   * @param  {Object} params The parameters used to resolve the decorator.
   * @param  {String} params.typeSpec The type spec used for the agent registration look up.
   * @returns {Promise} A promise that is resolved once the decoration has finished.
   */

  return function decorate(object, params) {
    if (!params || !params.typeSpec) {
      return Promise.reject(new Error('No params or typespec for decorate call'));
    }

    return baja.registry.getAgents("type:".concat(params.typeSpec), ['webEditors:IJavaScriptDecorator']).then(function (agentInfos) {
      var typeSpecs = agentInfos.map(function (obj) {
        return obj.id;
      });
      return typeSpecs.length ? StationRegistry.getInstance().resolveAll(typeSpecs).then(function (decorators) {
        return decorators.reduce(function (prom, dec) {
          return prom.then(function () {
            return dec(object, params);
          });
        }, Promise.resolve());
      }) : Promise.resolve();
    });
  };
});
