function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/util/Switchboard
 */
define(['Promise', 'underscore'], function (Promise, _) {
  'use strict'; ////////////////////////////////////////////////////////////////
  // Repeat policies
  ////////////////////////////////////////////////////////////////

  function _reject(sb, arg) {
    return Promise.reject(arg);
  }
  /**
   * Multiple calls always get rejected with the given error message.
   *
   * @inner
   * @param {String} err the error message
   */


  function alwaysRejectWith(err) {
    return function (sb, args, promise) {
      return _reject(sb, new Error(err));
    };
  }
  /**
   * Multiple calls just invoke like normal (as if we weren't tracking them).
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/util/Switchboard} sb
   * @param {Array} args the arguments passed to the duplicate call
   * @param {Promise} promise the ongoing promise
   * @returns {*} the result of the normal call
   */


  function invoke(sb, args, promise) {
    return sb.$invoke(sb.$name, args);
  }
  /**
   * Multiple calls get coalesced into whatever promise is currently running
   * (if you make 5 calls, calls 2 to 5 will resolve exactly the same as
   * call 1).
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/util/Switchboard} sb
   * @param {Array} args the arguments passed to the duplicate call
   * @param {Promise} promise the ongoing promise
   * @returns {Promise} the ongoing promise
   */


  function _returnOngoing(sb, args, promise) {
    return promise;
  }
  /**
   * Multiple calls get queued to execute, but only the most recent call stays.
   * If you make 5 calls, call 5 will execute after call 1. Calls 2, 3, and 4
   * will never resolve.
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/util/Switchboard} sb
   * @param {Array} args the arguments passed to the duplicate call
   * @param {Promise} promise the ongoing promise
   * @returns {*}
   */


  function _preempt(sb, args, promise) {
    var preemptQueue = sb.$preemptQueue,
        key = sb.$getKey(args),
        prom;

    if (!preemptQueue[key]) {
      // eslint-disable-next-line promise/avoid-new
      prom = new Promise(function (resolve, reject) {
        promise.then(function () {
          Promise.resolve(sb.$invoke(sb.$name, preemptQueue[key].args)).then(resolve, reject)["finally"](function () {
            delete preemptQueue[key];
          });
        })["catch"](reject);
      });
      preemptQueue[key] = {
        promise: prom,
        args: args
      };
    } else {
      prom = preemptQueue[key].promise;
      preemptQueue[key].args = args;
    }

    return prom;
  }
  /**
   * If promise(s) are currently executing, just pile up additional invocations
   * to ensure they all run non-concurrently and in order.
   * @inner
   * @param {module:nmodule/webEditors/rc/util/Switchboard} sb
   * @param {Array} args the arguments passed to the duplicate call
   * @param {Promise} promise the ongoing promise
   * @returns {Promise}
   */


  function _hold(sb, args, promise) {
    var preemptQueue = sb.$preemptQueue,
        key = sb.$getKey(args),
        prom = preemptQueue[key];

    if (!prom) {
      prom = promise.then(function () {
        return sb.$invoke(sb.$name, args);
      })["finally"](function () {
        delete preemptQueue[key];
      });
    } else {
      prom = prom.then(function () {
        return sb.$invoke(sb.$name, args);
      });
    }

    preemptQueue[key] = prom;
    return prom;
  } ////////////////////////////////////////////////////////////////
  // Resolve policies
  ////////////////////////////////////////////////////////////////

  /**
   * An ongoing promise is never marked as complete (used by once() to ensure
   * it never gets called again).
   */


  function never() {}
  /**
   * After the ongoing promise completes, remove it from the registry so it
   * can get called again as normal.
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/util/Switchboard} sb
   * @param {String} name the name of the ongoing function
   * @param {Promise} promise the promise that was just resolved
   */


  function forget(sb, name, promise) {
    var arr = sb.$reg[name],
        i = arr.indexOf(promise);
    arr.splice(i, 1);
  }
  /**
   * No throttling or orchestration of promise calls; just track them.
   *
   * @inner
   * @param sb
   * @param name
   * @param args
   * @returns {Promise}
   */


  function passThrough(sb, name, args) {
    return sb.$invoke(name, args);
  }
  /**
   * If there is already a call to function ongoing, pass the call through to
   * `$onRepeat`.
   *
   * @inner
   * @param sb
   * @param name
   * @param args
   * @returns {*}
   */


  function handleRepeats(sb, name, args) {
    var executingPromise = sb.$getExecutingPromise(args);

    if (executingPromise) {
      return sb.$onRepeat(sb, args, executingPromise);
    }

    return sb.$invoke(name, args);
  }

  function allCallsAreDuplicates() {
    return true;
  } ////////////////////////////////////////////////////////////////
  // Switchboard implementation
  ////////////////////////////////////////////////////////////////

  /**
   * A class for wrangling multiple calls to an async function that returns
   * a promise.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/util/Switchboard
   *
   * @param {Object} obj the object instance on whom you're going to call
   * the function.
   * @param {String} name the name of the function to track
   * @param {Object} executingPromises a registry that will keep references to
   * promises that are ongoing. This can include promises from other functions
   * than just the one specified by name.
   */


  var Switchboard = function Switchboard(obj, name, executingPromises) {
    var that = this,
        func = obj[name];

    if (typeof func !== 'function') {
      throw new Error('function ' + name + ' not found');
    }
    /**
     * The name of the function this Switchboard is managing.
     * @private
     * @type {String}
     */


    that.$name = name;
    /**
     * A registry of all functions that are being tracked (this can include
     * other functions besides just the managed function, since the managed
     * function might need to wait for others as well).
     * @private
     * @type {Object}
     */

    that.$tracked = {};
    /**
     * When multiple calls are being preempted, we must keep a queue of waiting
     * invocations.
     * @private
     * @type {Object}
     */

    that.$preemptQueue = {};
    /**
     * The object we're calling functions on.
     * @private
     * @type {Object}
     */

    that.$obj = obj;
    /**
     * The registry of all ongoing promises.
     * @private
     * @type {Object}
     */

    that.$reg = executingPromises;
    /**
     * A list of functions that need to complete before this one can execute.
     * @private
     * @type {Array}
     */

    that.$waitingOn = [name];
    /**
     * The way to handle repeat invocations. By default, it will just invoke
     * them as normal as if not tracked.
     * @private
     * @type {Function}
     */

    that.$onRepeat = invoke;
    /**
     * The way to handle a promise when it completes. By default, it will
     * forget it so it can be called again.
     * @private
     * @type {Function}
     */

    that.$onResolve = forget;
    that.$doGetKey = allCallsAreDuplicates;
    that.$orchestrate(name);
  };

  Switchboard.prototype = {
    /**
     * Add a function to the list of tracked functions. Just tracking the
     * function does not change its behavior; its behavior will only be changed
     * after calling another Switchboard function like `once()`.
     *
     * @private
     * @param {String} name the name of the function to track
     * @param {Function} handle a function to handle the invocation: what should
     * i do when this function is called? By default it will do nothing but
     * record the invocation and pass through to the original function.
     */
    $track: function $track(name, handle) {
      var that = this,
          obj = that.$obj,
          func = obj[name],
          oldSwitchboard = func.$sb;

      if (!handle) {
        handle = passThrough;
      }

      if (oldSwitchboard) {
        //console.error('warning: already tracked');
        func = oldSwitchboard.$tracked[name] || func;
      }

      obj[name] = function () {
        var args = Array.prototype.slice.call(arguments);
        return handle(that, name, args);
      };

      obj[name].$sb = that;
      that.$tracked[name] = func;
    },

    /**
     * Add a function to the list of tracked functions, and also add behavior to
     * defer/delay/reject duplicate or concurrent calls.
     *
     * @private
     * @param {String} name the name of the function to track
     */
    $orchestrate: function $orchestrate(name) {
      this.$track(name, handleRepeats);
    },

    /**
     * Stop tracking a function - allow it to function again as before.
     *
     * @private
     * @param {String} name the name of the function to forget
     */
    $forget: function $forget(name) {
      this.$onRepeat = invoke;
      this.$onComplete = forget;
    },

    /**
     * Stop tracking all functions - essentially disconnect from the tracked
     * object.
     *
     * @private
     */
    $forgetAll: function $forgetAll() {
      var tracked = this.$tracked;

      for (var name in tracked) {
        if (tracked.hasOwnProperty(name)) {
          this.$forget(name);
        }
      }
    },

    /**
     * Verifies that the switchboard is in a valid state to call the specified
     * function.
     * @private
     * @param {String} funcName the name of function to call
     * @param {String} context the required context
     */
    $checkContext: function $checkContext(funcName, context) {
      if (this.$context !== context) {
        throw new Error(funcName + '() can only be called after ' + context + '()');
      }
    },

    /**
     * Detect if there is a currently executing promise that matches the given
     * arguments. This may be another call to the same function that is managed
     * by this Switchboard, or a different function specified by `notWhile()`, or
     * both.
     *
     * @private
     * @param {Array} args the arguments given to the called function
     * @returns {Promise} the executing promise, or undefined if no
     * matching promise is executing right now
     */
    $getExecutingPromise: function $getExecutingPromise(args) {
      var that = this,
          reg = that.$reg,
          allNames = that.$waitingOn,
          key = that.$getKey(args),
          proms;
      proms = _.chain(allNames).map(function (name) {
        var currentInvocs = reg[name] || (reg[name] = []);
        return _.map(currentInvocs, function (obj) {
          if (that.$getKey(obj.args) === key) {
            return obj.promise;
          }
        });
      }).flatten().compact().value();

      if (proms.length) {
        return Promise.all(proms).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 1),
              prom = _ref2[0];

          return prom;
        });
      }
    },

    /**
     * Examine all arguments to a function call, and return a key that will be
     * used to determine duplicate calls.
     *
     * @private
     * @param {Array} args arguments to the function call
     * @returns {*}
     */
    $getKey: function $getKey(args) {
      return this.$doGetKey.apply(this, args);
    },

    /**
     * Performs the call back to the original function. Will be done if there
     * are no executing promises, no waiting or timeouts, no reason to delay or
     * defer the call to the original function - this causes the function we're
     * managing to actually happen.
     *
     * @private
     * @param {String} name the name of the function to invoke
     * @param {Array} args arguments to pass to the function
     * @returns {Promise}
     */
    $invoke: function $invoke(name, args) {
      var that = this,
          obj = that.$obj,
          trackedFunction = that.$tracked[name],
          reg = that.$reg,
          currentInvocs = reg[name] || (reg[name] = []),
          invoke = Promise["try"](function () {
        return trackedFunction.apply(obj, args);
      });
      currentInvocs.push({
        args: args,
        promise: invoke
      }); // eslint-disable-next-line promise/catch-or-return

      invoke.then(function () {
        that.$onResolve(that, name, invoke);
      });
      return invoke;
    },

    /**
     * Sets up a new Switchboard context for the specified function. `once()`,
     * `oneAtATime()`, etc. will apply to this function.
     *
     * @param {String} name the name of the function to manage
     * @returns {Switchboard} new Switchboard context
     */
    allow: function allow(name) {
      return new Switchboard(this.$obj, name, this.$reg);
    },

    /**
     * Prevents the allowed function from executing more than once. By default,
     * subsequent calls will resolve/reject exactly the same as the first call.
     *
     * @returns {Switchboard}
     *
     * @example
     *   new Switchboard(obj)
     *    .allow('oneTimeOperation')
     *    .once();
     */
    once: function once() {
      this.oneAtATime();
      this.$onResolve = never;
      this.$context = 'once';
      return this;
    },

    /**
     * After `once()`, forces all subsequent calls to always reject.
     *
     * @returns {Switchboard}
     *
     * @example
     *   new Switchboard(obj)
     *    .allow('reallyOneTimeOperation')
     *    .once().andRejectAfter();
     */
    andRejectAfter: function andRejectAfter() {
      this.$checkContext('andRejectAfter', 'once');
      this.$onRepeat = alwaysRejectWith('cannot call function "' + this.$name + '" more than once');
      return this;
    },

    /**
     * Prevents multiple calls to the allowed function from executing more than
     * once at a time. By default, subsequent calls will resolve/reject the same
     * way as the earliest call, until the earliest call resolves or rejects,
     * after which another call will invoke anew.
     *
     * @returns {Switchboard}
     *
     * @example
     *   new Switchboard(obj)
     *    .allow('neverParallel')
     *    .oneAtATime();
     */
    oneAtATime: function oneAtATime() {
      this.$context = 'oneAtATime';
      this.$onRepeat = _returnOngoing;
      this.$onResolve = forget;
      return this;
    },

    /**
     * Sets up the ability to specify how repeats are handled.
     *
     * @returns {Switchboard}
     */
    onRepeat: function onRepeat() {
      this.$checkContext('onRepeat', 'oneAtATime');
      this.$context = 'onRepeat';
      return this;
    },

    /**
     * Specifies how duplicate calls are detected. If `keyedOn` is never called,
     * all calls to the same function are treated as duplicates.
     *
     * Pass in a function that will receive the same parameters as the managed
     * function. This function should return a single value (for instance, return
     * a specific parameter directly, or hash multiple parameters). If two calls
     * to the same function return the same key, they are considered duplicates.
     *
     * @param {Function} func function that receives original parameters and
     * returns a key
     * @returns {Switchboard}
     *
     * @example
     *   <caption>
     *     Ensures that multiple calls to setVisible with the same value don't
     *     accumulate. So setVisible(true); setVisible(true); will only call it
     *     once, but setVisible(true); setVisible(false); will call it twice.
     *   </caption>
     *   new Switchboard(obj)
     *    .allow('setVisible')
     *      .oneAtATime()
     *      .keyedOn(function (visible) { return visible; });
     */
    keyedOn: function keyedOn(func) {
      this.$doGetKey = func;
      return this;
    },

    /**
     * Repeat policy that specifies that repeat calls get rejected.
     *
     * @example
     *   new Switchboard(obj)
     *     .allow('rejectOnDuplicate')
     *       .onRepeat().reject();
     */
    reject: function reject() {
      this.$checkContext('reject', 'onRepeat');
      this.$onRepeat = _reject;
    },

    /**
     * Repeat policy that specifies that repeat calls just return the ongoing
     * promise. This is the default in most cases.
     *
     * @example
     *   new Switchboard(obj)
     *     .allow('neverParallel')
     *       .onRepeat().returnOngoing();
     */
    returnOngoing: function returnOngoing() {
      this.$checkContext('returnOngoing', 'onRepeat');
      this.$onRepeat = _returnOngoing;
    },

    /**
     * Repeat policy that specifies that repeat calls do take effect, but only
     * the most recent call. Calls other than the earliest ongoing call and the
     * latest repeat call get dropped (never resolve or reject).
     *
     * @example
     *   new Switchboard(obj)
     *     .allow('repeatsAreLegit')
     *       .onRepeat().preempt();
     */
    preempt: function preempt() {
      this.$checkContext('preempt', 'onRepeat');
      this.$onRepeat = _preempt;
    },

    /**
     * Repeat policy that specifies that repeat calls do take effect, but not
     * concurrently; a repeat call will always wait for the previous call to
     * resolve before beginning.
     *
     * @example
     *   new Switchboard(obj)
     *     .allow('neverConcurrently')
     *     .onRepeat().hold();
     */
    hold: function hold() {
      this.$checkContext('hold', 'onRepeat');
      this.$onRepeat = _hold;
    },

    /**
     * Makes two different functions mutually exclusive (think add/remove,
     * expand/collapse, etc.). Ensures that calls to one function will wait
     * until ongoing calls to the other are completed. This is a one-way
     * operation, if the exclusivity goes both ways, be sure to set it up in
     * each direction.
     *
     * @param {String} name the name of the function to wait for
     * @returns {Switchboard}
     *
     * @example
     *   <caption>
     *     I can add or remove different values at the same time, but I can't
     *     both add and remove the same value at the same time.
     *   </caption>
     *   function theValue(val) { return val; }
     *
     *   new Switchboard(obj)
     *     .allow('addValue')
     *       .notWhile('removeValue').keyedOn(theValue)
     *     .allow('removeValue')
     *       .notWhile('addValue').keyedOn(theValue);
     */
    notWhile: function notWhile(name) {
      this.$track(name);
      this.$waitingOn.push(name);
      this.$onRepeat = _hold;
      return this;
    }
  }; //Switchboard.prototype
  ////////////////////////////////////////////////////////////////
  // The guy who makes Switchboards
  ////////////////////////////////////////////////////////////////

  function SwitchboardGenerator(obj) {
    if (_typeof(obj) !== 'object') {
      throw new Error('object required');
    }

    if (obj.$$switchboard) {
      obj.$$switchboard.$forgetAll();
    }

    obj.$$switchboard = this;
    this.$obj = obj;
    this.$reg = {};
    this.$boards = {};
  }

  SwitchboardGenerator.prototype.allow = function (name) {
    var boards = this.$boards,
        sb = new Switchboard(this.$obj, name, this.$reg);
    boards[name] = sb;
    return sb;
  };

  SwitchboardGenerator.prototype.$forgetAll = function () {
    var boards = this.$boards;

    for (var name in boards) {
      if (boards.hasOwnProperty(name)) {
        boards[name].$forgetAll();
        delete boards[name];
      }
    }
  };

  return SwitchboardGenerator;
});
