/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/util/I18NProvider
 */
define(['baja!', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (baja, Promise, asyncUtils) {
  'use strict';

  var doRequire = asyncUtils.doRequire,
      DEFAULT_MODULE = 'webEditors',
      DEFAULT_KEY = 'I18NProviderModule',
      instance;

  function doLex(module) {
    return baja.lex({
      module: module
    });
  }
  /**
   * Provides locale-specific internationalization functions.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/util/I18NProvider
   */


  var I18NProvider = function I18NProvider() {}; //TODO: specify a locale

  /**
   * Get the instance for the user's current locale. The instance will be
   * specified by the lexicon key `webEditors:I18NProviderModule`, which
   * should return an ORD or AMD module ID. This module should resolve to an
   * `I18NProvider` subclass.
   *
   * If the lexicon is not specified, the default instance resolved will follow
   * American English rules.
   *
   * @param {Object} [config] configuration options. If omitted, will resolve
   * the default instance.
   * @param {String} [config.module=webEditors] the lexicon module to look for
   * the specified I18NProvider module
   * @param {String} [config.key=I18NProviderModule] the key that specifies
   * the I18NProvider module ID
   * @returns {jQuery.Promise} promise to be resolved with an `I18NProvider`
   * instance
   */


  I18NProvider.get = function (config) {
    if (!config) {
      return Promise.resolve(instance || (instance = new I18NProvider()));
    }

    var module = config && config.module,
        key = config && config.key;
    return doLex(module || DEFAULT_MODULE).then(function (lex) {
      var id = lex.get(key || DEFAULT_KEY);
      return doRequire(id);
    }).then(function (Ctor) {
      return new Ctor();
    });
  };
  /**
   * Convert a number to its ordinal string (1 -> 1st, 2 -> 2nd, etc).
   *
   * @param {Number} number an integer to convert to ordinal string
   * @returns {String}
   */


  I18NProvider.prototype.ordinal = function (number) {
    var abs = Math.abs(number),
        lastDigit = abs % 10,
        secondLastDigit = Math.floor(abs % 100 / 10),
        suffix = secondLastDigit === 1 ? 'th' : lastDigit === 1 ? 'st' : lastDigit === 2 ? 'nd' : lastDigit === 3 ? 'rd' : 'th';
    return number + suffix;
  };

  return I18NProvider;
});
