function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/export/rc/transformers/TableModelToCsv
 */
define(['baja!', 'lex!webEditors', 'Promise', 'underscore', 'niagaraSystemProperties', 'nmodule/webEditors/rc/transform/transformer/TableModelToJson', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'baja!file:ITableToCsv'], function (baja, lexs, Promise, _, systemProperties, TableModelToJson, typeUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      webEditorsLex = _lexs[0],
      isSimple = typeUtils.isSimple;
  /**
   * Converts a TableModel or PaginationModel to CSV format.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/transform/transformer/TableModelToCsv
   * @implements module:nmodule/export/rc/Transformer
   */


  var TableModelToCsv = /*#__PURE__*/function () {
    function TableModelToCsv() {
      _classCallCheck(this, TableModelToCsv);
    }

    _createClass(TableModelToCsv, [{
      key: "getDisplayName",

      /** @returns {string} */
      value: function getDisplayName() {
        return webEditorsLex.get('converters.TableModelToCsv.displayName');
      }
      /** @returns {string} */

    }, {
      key: "getIcon",
      value: function getIcon() {
        return webEditorsLex.get('converters.TableModelToCsv.icon');
      }
      /** @returns {string} `text/csv` */

    }, {
      key: "getMimeType",
      value: function getMimeType() {
        return 'text/csv';
      }
      /** @returns {string} `csv` */

    }, {
      key: "getFileExtension",
      value: function getFileExtension() {
        return 'csv';
      }
      /** @returns {string} `table` */

    }, {
      key: "getFileName",
      value: function getFileName() {
        return 'table';
      }
      /**
       * @returns {baja.Component}
       */

    }, {
      key: "getDefaultConfig",
      value: function getDefaultConfig() {
        var comp = baja.$('file:ITableToCsv');
        comp.add({
          slot: 'showUnseen',
          value: true,
          cx: {
            displayName: webEditorsLex.get('export.showUnseen')
          }
        });
        comp.add({
          slot: 'maxRecords',
          value: baja.Integer.MAX_VALUE,
          cx: {
            displayName: webEditorsLex.get('export.maxRecords')
          }
        });
        return comp;
      }
      /**
       * @param {baja.Component} config
       * @returns {object}
       */

    }, {
      key: "getExportContextObject",
      value: function getExportContextObject(config) {
        var obj = config.getSlots().toValueMap(),
            lineEnding = obj.useCRLF ? '\r\n' : '\n';
        return _.extend(_.omit(obj, 'facets', 'useCRLF'), obj.facets.toObject(), {
          lineEnding: lineEnding
        });
      }
      /**
       * Transform the contents of the TableModel or PaginationModel into CSV.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel|module:nmodule/webEditors/rc/wb/table/pagination/PaginationModel} tableModel
       * @param {object} [cx] context; also used for toString()ing values
       * @param {string} [cx.delimiter=','] custom delimiter
       * @param {boolean} [cx.includeBOM=true] set to false to omit the UTF-8
       * byte order mark from the CSV (be aware that omitting the BOM does not
       * play nice with Excel)
       * @param {boolean} [cx.includeHeaders=true] set to false to not include
       * header columns in the CSV
       * @param {string} [cx.lineEnding='\n'] choose a custom line ending like \r\n
       * @param {boolean} [cx.showUnseen=true] set to false to prevent unseen
       * columns from being included
       * @returns {Promise.<string>}
       */

    }, {
      key: "transform",
      value: function transform(tableModel) {
        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var _cx$delimiter = cx.delimiter,
            delimiter = _cx$delimiter === void 0 ? ',' : _cx$delimiter,
            _cx$includeHeaders = cx.includeHeaders,
            includeHeaders = _cx$includeHeaders === void 0 ? true : _cx$includeHeaders,
            _cx$lineEnding = cx.lineEnding,
            lineEnding = _cx$lineEnding === void 0 ? '\n' : _cx$lineEnding,
            _cx$includeBOM = cx.includeBOM,
            includeBOM = _cx$includeBOM === void 0 ? true : _cx$includeBOM;

        if (this.delimiterContainsFunctionCharacter(delimiter)) {
          throw new Error(webEditorsLex.get('export.delimiterFunctionError'));
        }

        return new TableModelToJson().transform(tableModel, _.extend({}, cx, {
          rawJson: true
        })).then(function (_ref) {
          var columns = _ref.columns,
              rows = _ref.rows,
              columnContexts = _ref.$metadata.columnContexts;
          var escapeRegex = new RegExp('[' + delimiter + '\\n]');
          var header = includeBOM ? "\uFEFF" : '';

          if (includeHeaders) {
            header += columns.map(function (c) {
              return escape(c, escapeRegex);
            }).join(delimiter) + lineEnding;
          } // never show units in individual cells.


          columnContexts = columnContexts.map(function (columnContext) {
            return _.extend({
              precision: 0
            }, columnContext, {
              showUnits: false
            });
          });
          return Promise.all(rows.map(function (row) {
            return Promise.all(row.map(function (value, i) {
              return valueToCell(value, escapeRegex, columnContexts[i]);
            })).then(function (cells) {
              return cells.join(delimiter);
            });
          })).then(function (rowStrings) {
            return header + rowStrings.join(lineEnding);
          });
        });
      }
      /**
       * Returns true if delimiter.substring(1) contains one of the function characters
       *  =, +, -, @.
       *
       * @param delimiter
       * @returns {boolean}
       */

    }, {
      key: "delimiterContainsFunctionCharacter",
      value: function delimiterContainsFunctionCharacter(delimiter) {
        return delimiter.indexOf('=') > 0 || delimiter.indexOf('+') > 0 || delimiter.indexOf('-') > 0 || delimiter.indexOf('@') > 0;
      }
    }]);

    return TableModelToCsv;
  }();
  /** @returns {Promise.<string>} */


  function valueToCell(value, escapeRegex, cx) {
    if (value === null || typeof value === 'undefined') {
      return Promise.resolve('');
    }

    return Promise.resolve(isSimple(value) ? value.toString(cx) : String(value)).then(function (string) {
      return escape(string, escapeRegex);
    });
  }

  function escape(string, escapeRegex) {
    string = string.replace(/"/g, '""');

    if (preventCSVInjection()) {
      string = string.replace(/^[=@+-]/g, " $&");
    }

    return string.match(escapeRegex) ? "\"".concat(string, "\"") : string;
  }

  function preventCSVInjection() {
    var flagString = systemProperties['niagara.export.preventCSVInjection'];

    if (flagString) {
      var B = Boolean;
      var flag = new B().decodeFromString(flagString);
      return flag.valueOf();
    } else {
      // default value is true
      return true;
    }
  }

  return TableModelToCsv;
});
