function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/transform/transformer/ExporterTransformer
 */
define(['baja!', 'underscore', 'Promise', 'jquery', 'nmodule/export/rc/Transformer', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, _, Promise, $, Transformer, compUtils, typeUtils) {
  'use strict';

  var getNavOrd = compUtils.getNavOrd,
      toObject = compUtils.toObject;
  var isSimple = typeUtils.isSimple;
  /**
   * A Transformer for a generic object.
   * This version does not care about the object, rather gets the contents of the view using $.get
   *
   * @extends module:nmodule/export/rc/Transformer
   * @class
   * @alias module:nmodule/webEditors/rc/transform/transformer/ExporterTransformer
   */

  var ExporterTransformer = /*#__PURE__*/function (_Transformer) {
    _inherits(ExporterTransformer, _Transformer);

    var _super = _createSuper(ExporterTransformer);

    /**
     * @param {module:nmodule/webEditors/rc/transform/exportUtils~ExporterInfo} exporterInfo
     */
    function ExporterTransformer(exporterInfo) {
      var _this;

      _classCallCheck(this, ExporterTransformer);

      _this = _super.call(this);
      _this.$transformType = exporterInfo.typeSpec;
      _this.$id = exporterInfo.id;
      _this.$displayName = exporterInfo.displayName;
      _this.$icon = exporterInfo.icon;
      _this.$viewOrd = 'view:' + _this.$transformType;
      _this.$expProps = exporterInfo.props;
      return _this;
    }
    /**
     * @returns {Promise.<baja.Component>} resolves to an instance of the
     * `baja:Exporter` being used
     */


    _createClass(ExporterTransformer, [{
      key: "getDefaultConfig",
      value: function getDefaultConfig() {
        var type = this.getExporterTypeSpec();
        return baja.importTypes([type]).then(function () {
          return baja.$(type);
        });
      }
      /**
       * @param {baja.Component} config the user-edited `baja:Exporter` instance
       * @returns {object} context object filtered to contain only `Simple`
       * properties (`Complex`es are not supported by `OrdServlet`)
       */

    }, {
      key: "getExportContextObject",
      value: function getExportContextObject(config) {
        return toObject(config, {
          filter: function filter(slot) {
            return isSimple(config.get(slot));
          }
        });
      }
    }, {
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$displayName;
      }
    }, {
      key: "getIcon",
      value: function getIcon() {
        return this.$icon;
      }
    }, {
      key: "getMimeType",
      value: function getMimeType() {
        return this.$expProps && this.$expProps.mimeType;
      }
      /**
       * @returns {string} The response type of this Transformer
       */

    }, {
      key: "getResponseType",
      value: function getResponseType() {
        return this.$expProps && this.$expProps.responseType;
      }
      /**
       * @returns {string} The file extension of this Transformer
       */

    }, {
      key: "getFileExtension",
      value: function getFileExtension() {
        return this.$expProps && this.$expProps.fileExt;
      }
      /**
       * Generate a file name from the Id or return an empty string
       *
       * @returns {string} An empty string or export file name
       */

    }, {
      key: "getFileName",
      value: function getFileName() {
        if (this.$id !== this.$transformType) {
          return this.$id.split('/')[0];
        }

        return 'file';
      }
      /**
       * @returns {string} the type spec of the `baja:Exporter` to be used
       */

    }, {
      key: "getExporterTypeSpec",
      value: function getExporterTypeSpec() {
        return this.$transformType;
      }
      /**
       * Gets the contents of the view
       *
       * @param {baja.Value} object
       * @param {object} [cx]
       * @returns {Promise.<*>} Returns a Promise that resolves to the contents
       * of the view ord
       */

    }, {
      key: "transform",
      value: function transform(object, cx) {
        var _this2 = this;

        return this.getTransformOrd(object, cx).then(function (transformOrd) {
          var params = {
            url: transformOrd.toUri(),
            xhrFields: {
              responseType: _this2.$expProps.responseType
            }
          };

          if (_this2.$isTextResponse(_this2.$expProps.responseType)) {
            params.dataType = 'text';
          }

          return $.ajax(params);
        });
      }
      /**
       * Get a direct link to the exporter
       *
       * @param {baja.Value} object
       * @param {object} [cx] export context
       * @returns {Promise.<baja.Ord>} station-side exporter ORD
       */

    }, {
      key: "getTransformOrd",
      value: function getTransformOrd(object) {
        var _this3 = this;

        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        return getNavOrd(object).then(function (navOrd) {
          if (!navOrd) {
            throw new Error(object + ': Unsupported export object.');
          }

          return baja.Ord.make({
            base: _this3.$getBaseOrd(navOrd),
            child: _this3.$getChildOrd(cx)
          }).normalize();
        });
      }
      /**
       *
       * @private
       * @param {baja.Ord} navOrd
       */

    }, {
      key: "$getBaseOrd",
      value: function $getBaseOrd(navOrd) {
        var baseOrd = navOrd.toString(); // Strip the trailing slash if the navOrd ends with / - true for station root and virtuals

        if (baseOrd.match('/$')) {
          baseOrd = baseOrd.substring(0, baseOrd.length - 1);
        }

        return baseOrd;
      }
      /**
       *
       * @private
       */

    }, {
      key: "$getChildOrd",
      value: function $getChildOrd(cx) {
        var childViewOrd = this.$viewOrd;

        if (this.$isPxView()) {
          childViewOrd = 'view:' + this.$id;
        }

        return childViewOrd + contextToUrlParameters(cx);
      }
      /**
       * A PxView agent on a component is distinguished from other
       * agents only via an ID which is of the form
       * pxViewName/subId where subId is typically the module name of the Exporter.
       * For example, Graphic/pdf is the agent ID of a PxView with slot name 'Graphic'
       * and 'pdf' is the module name of the pdf:PxViewToPdf Exporter
       *
       * @private
       */

    }, {
      key: "$isPxView",
      value: function $isPxView() {
        return this.$id !== this.$transformType;
      }
      /**
       *
       * @private
       * @param {String} responseType
       */

    }, {
      key: "$isTextResponse",
      value: function $isTextResponse(responseType) {
        return responseType !== 'blob';
      }
    }]);

    return ExporterTransformer;
  }(Transformer);

  function contextToUrlParameters(cx) {
    var urlParams = {};

    if (_typeof(cx) === "object") {
      _.extend(urlParams, cx);
    }

    var keys = Object.keys(urlParams),
        enc = encodeURIComponent;

    if (!keys.length) {
      return '';
    }

    var valueNeedsEncoding = false;
    keys.forEach(function (key) {
      urlParams[key] = urlParams[key].encodeToString();

      if (valueNeedsEscaping(urlParams[key])) {
        valueNeedsEncoding = true;
        urlParams[key] = baja.SlotPath.escape(urlParams[key]);
      }
    });

    if (valueNeedsEncoding) {
      urlParams['ve'] = true;
      keys = Object.keys(urlParams);
    }

    return '?' + keys.map(function (key) {
      return "".concat(enc(key), "=").concat(enc(urlParams[key]));
    }).join(';');
  }

  function valueNeedsEscaping(paramValue) {
    var reservedChars = ['%', '|', '='];
    return reservedChars.reduce(function (rc, value) {
      return rc || paramValue.indexOf(value) !== -1;
    }, false);
  }

  return ExporterTransformer;
});
