function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/*eslint-env browser */

/*jshint browser: true */

/* globals niagara */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/transform/destination/StationFileDestinationType
 */
define(['baja!', 'lex!webEditors', 'jquery', 'Promise', 'underscore', 'nmodule/export/rc/ExportDestinationType', 'nmodule/js/rc/csrf/csrfUtil', 'nmodule/webEditors/rc/servlets/views', 'nmodule/webEditors/rc/transform/exportUtils', 'nmodule/webEditors/rc/transform/transformer/ExporterTransformer', 'nmodule/webEditors/rc/util/fileUtils'], function (baja, lexes, $, Promise, _, ExportDestinationType, csrfUtil, views, exportUtils, ExporterTransformer, fileUtils) {
  'use strict';

  var _lexes = _slicedToArray(lexes, 1),
      webEditorsLex = _lexes[0],
      CSRF_TOKEN_HEADER_KEY = csrfUtil.CSRF_TOKEN_HEADER_KEY,
      getCsrfToken = csrfUtil.getCsrfToken,
      getFileName = exportUtils.getFileName,
      getFilePath = exportUtils.getFilePath;
  /**
   * Destination for sending an export operation to a file in the file user home on the station.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/transform/destination/StationFileDestinationType
   */


  var StationFileDestinationType = /*#__PURE__*/function (_ExportDestinationTyp) {
    _inherits(StationFileDestinationType, _ExportDestinationTyp);

    var _super = _createSuper(StationFileDestinationType);

    function StationFileDestinationType() {
      _classCallCheck(this, StationFileDestinationType);

      return _super.apply(this, arguments);
    }

    _createClass(StationFileDestinationType, [{
      key: "checkValid",

      /**
       * @throws {Error} if BajaScript is offline
       */
      value: function checkValid() {
        if (baja.isOffline()) {
          throw new Error('BajaScript is offline');
        }
      }
    }, {
      key: "getDisplayName",
      value: function getDisplayName() {
        return webEditorsLex.get('export.destination.stationFile.displayName');
      }
    }, {
      key: "prepare",
      value: function prepare(transformOp) {
        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var fileOrd = cx.fileOrd;
        return checkPermissions(fileOrd).then(function () {
          return fileUtils.confirmServerFileWrite(fileOrd);
        });
      }
      /**
       * Writes the file found in cx.fileOrd to the server.
       *
       * @param {module:nmodule/export/rc/TransformOperation} transformOp
       * @param {object} [cx]
       * @param {string} [cx.fileOrd]
       * @param {string} [cx.viewOnExport=false]
       * @returns {Promise}
       */

    }, {
      key: "transform",
      value: function transform(transformOp) {
        var _this = this;

        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var fileOrd = cx.fileOrd;
        return checkPermissions(fileOrd).then(function () {
          return _this.$saveToStation(transformOp, cx);
        })["catch"](function () {
          throw new Error(webEditorsLex.get('export.fileUploadFailed'));
        });
      }
      /**
       * @private
       * @param {module:nmodule/export/rc/TransformOperation} transformOp
       * @param {object} cx
       */

    }, {
      key: "$saveToStation",
      value: function $saveToStation(transformOp, cx) {
        var _this2 = this;

        var fileOrd = cx.fileOrd;

        var saveToStation = function saveToStation() {
          var transformer = transformOp.getTransformer();

          if (transformer instanceof ExporterTransformer) {
            return transformer.getTransformOrd(transformOp.getTransformedObject()).then(function (ordToExport) {
              return exportUtils.exportToStationFile(ordToExport, fileOrd, transformer.getExporterTypeSpec(), cx);
            });
          }

          return transformOp.doTransform(cx).then(function (data) {
            return _this2.$post(fileOrd, data);
          });
        };

        return saveToStation().then(function () {
          return cx.viewOnExport && _this2.$showView(cx);
        });
      }
      /**
       * Get the component to be loaded in as the destination config
       *
       * @param {module:nmodule/export/rc/TransformOperation} transformOp The transform operation this destination type is a target for
       * @returns {baja.Component} The destination config component.
       */

    }, {
      key: "getDestinationConfig",
      value: function getDestinationConfig(transformOp) {
        var comp = baja.$('baja:Component'),
            fileName = getFileName(transformOp, this),
            filePath = getFilePath(transformOp, this),
            fullFileName = filePath ? filePath + "/" + fileName : fileName;
        comp.add({
          slot: 'fileName',
          value: fullFileName,
          cx: {
            displayName: webEditorsLex.get('export.fileName')
          }
        });
        comp.add({
          slot: 'viewOnExport',
          value: false,
          cx: {
            displayName: webEditorsLex.get('export.viewOnExport')
          }
        });
        return comp;
      }
      /**
       * Converts a config Component into a destination context object.
       *
       * @param {baja.Component} config The destination config component
       * @returns {object|Promise<object>}
       */

    }, {
      key: "getDestinationContextObject",
      value: function getDestinationContextObject(config) {
        var cx = _get(_getPrototypeOf(StationFileDestinationType.prototype), "getDestinationContextObject", this).call(this, config);

        return _.extend({
          fileOrd: 'file:^' + cx.fileName
        }, _.omit(cx, 'fileName'));
      }
      /**
       * @private
       */

    }, {
      key: "$getViewOrd",
      value: function $getViewOrd(viewList) {
        return viewList.length > 1 ? viewList.filter(function (view) {
          return view.typeName !== 'FileDownloadView' && view.moduleName !== 'web';
        })[0].ord : viewList[0].ord;
      }
      /**
       * @private
       */

    }, {
      key: "$showView",
      value: function $showView(cx) {
        var _this3 = this;

        return views.listViews(cx.fileOrd).then(function (viewList) {
          var resultOrd = _this3.$getViewOrd(viewList);

          return niagara.env.hyperlink(resultOrd);
        });
      }
      /**
       * @private
       * @param {string} fileOrd the ORD to the file to write
       * @param {*} data the contents of the file
       * @returns {Promise}
       */

    }, {
      key: "$post",
      value: function $post(fileOrd, data) {
        var formData = new FormData();
        formData.append('ord', fileOrd);
        formData.append('content', data);
        return Promise.resolve($.ajax({
          url: '/file',
          headers: _defineProperty({}, CSRF_TOKEN_HEADER_KEY, getCsrfToken()),
          data: formData,
          contentType: false,
          processData: false,
          method: 'POST'
        }));
      }
    }]);

    return StationFileDestinationType;
  }(ExportDestinationType);
  /**
   * @param {String} ord file ORD to write to
   * @returns {Promise} to be resolved if the user has write permissions, or
   * rejected if not
   */


  function checkPermissions(ord) {
    return fileUtils.isWritable(ord).then(function (writable) {
      if (!writable) {
        throw new Error('not writable');
      }
    });
  }

  return StationFileDestinationType;
});
