function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/transform/TableTransformOperationProvider
 */
define(['Promise', 'nmodule/export/rc/TransformOperation', 'nmodule/webEditors/rc/transform/transformer/TableModelToCsv', 'nmodule/webEditors/rc/transform/transformer/TableModelToJson', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/pagination/PaginationModel'], function (Promise, TransformOperation, TableModelToCsv, TableModelToJson, Table, TableModel, PaginationModel) {
  'use strict';
  /**
   * @class
   * @alias module:nmodule/webEditors/rc/transform/TableTransformOperationProvider
   * @implements module:nmodule/export/rc/TransformOperationProvider
   */

  var TableTransformOperationProvider = /*#__PURE__*/function () {
    function TableTransformOperationProvider() {
      _classCallCheck(this, TableTransformOperationProvider);
    }

    _createClass(TableTransformOperationProvider, [{
      key: "getTransformOperations",

      /**
       * @param {*} subject
       * @returns {Promise.<Array.<module:nmodule/export/rc/TransformOperation>>}
       */
      value: function getTransformOperations(subject) {
        var tableModel = getTableModel(subject);

        if (tableModel) {
          return Promise.resolve([new TransformOperation(new TableModelToCsv(), tableModel), new TransformOperation(new TableModelToJson(), tableModel)]);
        }

        return Promise.resolve([]);
      }
    }]);

    return TableTransformOperationProvider;
  }();

  function getTableModel(obj) {
    if (obj instanceof Table) {
      obj = obj.value();
    }

    if (obj instanceof TableModel || obj instanceof PaginationModel) {
      return obj;
    }
  }

  return TableTransformOperationProvider;
});
