function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/transform/ServletViewTransformOperationProvider
 */
define(['baja!', 'Promise', 'nmodule/webEditors/rc/transform/exportUtils'], function (baja, Promise, exportUtils) {
  'use strict';

  var getTransformOperationsAsAgents = exportUtils.getTransformOperationsAsAgents;
  /**
   * @class
   * @alias module:nmodule/webEditors/rc/transform/ServletViewTransformOperationProvider
   * @implements module:nmodule/export/rc/TransformOperationProvider
   */

  var ServletViewTransformOperationProvider = /*#__PURE__*/function () {
    function ServletViewTransformOperationProvider() {
      _classCallCheck(this, ServletViewTransformOperationProvider);
    }

    _createClass(ServletViewTransformOperationProvider, [{
      key: "getTransformOperations",

      /**
       * Returns the TransformOperations for this subject
       *
       * @param {module:nmodule/webEditors/rc/wb/profile/ServletViewWidget} subject
       * @returns {Promise.<Array.<module:nmodule/export/rc/TransformOperation>>}
       */
      value: function getTransformOperations(subject) {
        if (!subject) {
          return Promise.resolve([]);
        }

        var value = subject.getOrd();
        return getTransformOperationsAsAgents(value);
      }
    }]);

    return ServletViewTransformOperationProvider;
  }();

  return ServletViewTransformOperationProvider;
});
