function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/transform/ExportCommand
 */
define(['lex!webEditors', 'dialogs', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/transform/config/ExportDialog', 'nmodule/webEditors/rc/transform/exportUtils', 'nmodule/webEditors/rc/util/textUtils'], function (lexs, dialogs, Promise, _, Command, feDialogs, ExportDialog, exportUtils, textUtils) {
  'use strict';

  var subjectToDisplay = textUtils.subjectToDisplay;

  var _lexs = _slicedToArray(lexs, 1),
      webEditorsLex = _lexs[0];
  /**
   * Command for exporting a given object.
   *
   * @class
   * @extends {module:bajaux/commands/Command}
   * @alias module:nmodule/webEditors/rc/transform/ExportCommand
   */


  var ExportCommand = /*#__PURE__*/function (_Command) {
    _inherits(ExportCommand, _Command);

    var _super = _createSuper(ExportCommand);

    /**
     * @param {*} subject the subject to be exported
     */
    function ExportCommand(subject) {
      var _this;

      _classCallCheck(this, ExportCommand);

      _this = _super.call(this, {
        module: 'webEditors',
        lex: 'commands.export',
        func: function func() {
          return _this.readExportConfig().then(function (config) {
            return config && _this.doExport(config)["catch"](function (error) {
              //This catch is specific to the 'doExport' because 'readExportConfig' has its own catch handling in feDialog which shows an
              // error dialog, then rejects so we don't want to see the same error twice in two different dialogs.
              feDialogs.error(error);
            });
          });
        }
      });
      _this.$subject = subject;
      return _this;
    }
    /**
     * Prompt the user for configuration details about their export operation.
     * @returns {Promise.<module:nmodule/webEditors/rc/transform/config/ExportDialog~ExportConfig>}
     */


    _createClass(ExportCommand, [{
      key: "readExportConfig",
      value: function readExportConfig() {
        var subject = this.$subject;
        return subjectToDisplay(subject).then(function (display) {
          return feDialogs.showFor({
            title: webEditorsLex.get('commands.export.dialog.title', display),
            value: subject,
            type: ExportDialog
          });
        });
      }
      /**
       * Perform the export operation using the user's selected configuration.
       * @param {module:nmodule/webEditors/rc/transform/config/ExportDialog~ExportConfig} config
       * @returns {Promise}
       */

    }, {
      key: "doExport",
      value: function doExport(config) {
        var transformOp = config.transformOp,
            destination = config.destination,
            destContext = config.destContext,
            exportContext = config.exportContext;

        var cx = _.extend({}, destContext, exportContext);

        var transformerSupplier = exportUtils.isTransformerSupplier(transformOp);
        return Promise["try"](function () {
          return transformerSupplier ? destination.prepare(transformOp, cx) : true;
        }).then(function (shouldWrite) {
          if (shouldWrite) {
            var promise = transformerSupplier ? destination.transform(transformOp, cx) : transformOp.doTransform(cx);
            dialogs.showLoading(500, promise);
            return promise;
          }
        });
      }
    }]);

    return ExportCommand;
  }(Command);

  return ExportCommand;
});
