/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara*/
define(['jquery', 'Promise'], function ($, Promise) {
  'use strict';

  var SERVLET_URI = '/view/all/ord/';

  function doGet(uri) {
    return Promise.resolve($.get(uri));
  }
  /**
   * API Status: **Private**
   *
   * Functions for retrieving information about what kinds of views are
   * available on a particular ORD.
   *
   * This module communicates with the following servlets:
   *
   * - com.tridium.web.servlets.ViewAllOrdServlet
   *
   * @exports nmodule/webEditors/rc/servlets/views
   */


  var exports = {};
  /**
   * List the available views on this ord as an array of view objects.
   * If a `niagara.env.listViews` function is available and returns a truthy result, it will be used instead of the servlet.
   *
   * @param {baja.Ord|String} ord
   * @returns {Promise.<BajaViewInfo[]>} promise to be resolved with an
   * array of view objects
   */

  exports.listViews = function (ord) {
    if (typeof niagara !== 'undefined' && niagara.env && typeof niagara.env.listViews === 'function') {
      var stringResult = niagara.env.listViews(ord);

      if (stringResult) {
        return Promise.resolve(JSON.parse(stringResult).list);
      }
    }

    return doGet(SERVLET_URI + encodeURIComponent(ord)).then(function (obj) {
      return obj.list;
    });
  };

  return exports;
});
