function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'Promise', 'underscore'], function (baja, Promise, _) {
  'use strict';

  var RPC_TYPE_ORD = 'type:webEditors:TypeConfigRpc';

  var getTypeConfigInfo = _.chain(baja.rpc).bind(baja).partial(RPC_TYPE_ORD, 'getTypeConfigInfo').memoize().value();

  var getConfigurableInfo = _.chain(baja.rpc).bind(baja).partial(RPC_TYPE_ORD, 'getConfigurableInfo').memoize(String.prototype.concat).value();

  function decodeAsync(str) {
    return baja.bson.decodeAsync(JSON.parse(str));
  }
  /**
   * API Status: **Private**
   *
   * Utilities for retrieving information about `BTypeConfig` and
   * `IConfigurable` Types from the station.
   *
   * This module communicates with the following RPC services:
   *
   * - `com.tridium.webeditors.servlets.BTypeConfigRpc`
   *
   * @exports nmodule/webEditors/rc/servlets/typeConfig
   */


  var exports = {};
  /**
   * Retrieve information about the given `BTypeConfig` class. The resolved
   * object will contain the following properties:
   *
   * - `defaultType`: the default type to preselect, if none is set
   * - `targetType`: only types extending this type should be available for
   *   selection
   *
   * To illustrate, the info retrieved for `web:WebProfileConfig` would have
   * `hx:HTML5HxProfile` as the `defaultType` (that should be
   * preselected on a brand new web profile) and `targetType` would be
   * `web:IWebProfile` (only subtypes of that should be available to the user).
   *
   * @param {String} typeSpec
   * @returns {Promise.<{ defaultType: string, targetType: string }>} promise
   * to be resolved with an object literal containing `BTypeConfig` info
   */

  exports.getTypeConfigInfo = function (typeSpec) {
    return getTypeConfigInfo(String(typeSpec)).then(_.clone); //safe copy
  };
  /**
   * Retrieve information about the given `BTypeConfig.IConfigurable` class.
   * The resolved object will contain the following properties:
   *
   * - `config`: an array of objects corresponding to each key provided by
   *   the `IConfigurable`
   *
   * Each object in the `config` array will contain the following properties:
   *
   * - `key`: the string identifying that config object
   * - `displayName`: a display name string for that key
   * - `facets`: a `baja.Facets` for that config object
   * - `value`: the default `baja.Value` for that config object
   *
   * @param {String} typeConfigSpec
   * @param {String} configurableSpec
   * @returns {Promise} promise to be resolved with an object literal
   * containing `IConfigurable` info
   */


  exports.getConfigurableInfo = function (typeConfigSpec, configurableSpec) {
    // { config: [ { 'displayName', 'facets', 'key', 'value' } ] }
    // since we're memoizing, we need to return a safe copy
    return getConfigurableInfo(String(typeConfigSpec), String(configurableSpec)).then(function (_ref) {
      var config = _ref.config;
      return Promise.all(_.map(config, decodeConfigObject));
    }).then(function (config) {
      return {
        config: config
      };
    });
  };

  function decodeConfigObject(obj) {
    var facets = obj.facets,
        value = obj.value;
    return Promise.all([decodeAsync(facets), decodeAsync(value)]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
          facets = _ref3[0],
          value = _ref3[1];

      return _.extend({}, obj, {
        facets: facets,
        value: value
      });
    });
  }

  return exports;
});
