function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'Promise', 'underscore'], function (baja, Promise, _) {
  'use strict';

  function registryRpc(method) {
    return _.chain(function (batch) {
      return baja.rpc({
        typeSpec: 'web:RegistryRpc',
        method: method,
        args: _.toArray(arguments).slice(1),
        batch: batch
      });
    }).memoize(function () {
      //memoize on all arguments except batch
      return _.flatten(_.toArray(arguments).slice(1)).join();
    }).value();
  }

  var listModules = registryRpc('listModules'),
      listTypesForModules = registryRpc('listTypesForModules'),
      listTypes = registryRpc('listTypes');
  /**
   * API Status: **Private**
   *
   * Utility module for managing requests to the station's registry RPC API.
   *
   * This module communicates with the following RPC services:
   *
   * - `com.tridium.web.servlets.BRegistryRpc`
   *
   * @exports nmodule/webEditors/rc/servlets/registry
   */

  var exports = {}; ////////////////////////////////////////////////////////////////
  // Utility functions
  ////////////////////////////////////////////////////////////////

  /**
   * Handle a single argument or array of arguments, passing them through the
   * same function that always accepts an array.
   *
   * @inner
   * @param {*} arg
   * @param {Function} func
   * @param {Array} [args]
   * @returns {Promise}
   */

  function handleSingleOrArray(arg, func, args) {
    var isArray = Array.isArray(arg),
        arr = isArray ? arg : [arg];
    return func.apply(null, [arr].concat(args || [])).then(function (obj) {
      var objects = _.map(arr, function (key) {
        return obj[key];
      });

      return isArray ? objects : objects[0];
    });
  }
  /**
   * After the module refactor, querying the registry for all modules will
   * consider, say, `hierarchy-rt` and `hierarchy-ux` as separate modules. The
   * user only wants to see `hierarchy`.
   *
   * Go through the array of raw module info objects and group them into
   * single objects by logical module name.
   *
   * @inner
   * @param {Array.<Object>} modules
   * @returns {Array.<Object>}
   */


  function coalesceModules(modules) {
    var map = new baja.OrderedMap();

    _.each(modules, function (module) {
      //TODO: what happens if different rp's have different descriptions?
      var moduleName = module.m,
          existing = map.get(moduleName);

      if (existing) {
        var parts = existing.parts || (existing.parts = []);
        parts.push(module);
      } else {
        map.put(module.m, module);
      }
    });

    return _.map(map.getKeys(), function (key) {
      return _.clone(map.get(key)); //safe copy, since we're memoizing
    });
  } //TODO: caching badly needed here.

  /**
   * RPC to web:RegistryRpc.listModules
   * @inner
   * @returns {Promise} promise to be resolved with an array of module info
   */


  function listModulesRpc(params) {
    return listModules(params.batch, !!params.withTypesOnly, params.showInterface !== false, params.showAbstract !== false, String(params.targetType || ''));
  }
  /**
   * RPC to web:RegistryRpc.listTypesForModules
   * @inner
   * @returns {Promise} promise to be resolved with an object mapping module
   * name to array of type info
   */


  function listTypesForModulesRpc(modules, params) {
    return listTypesForModules(params.batch, _.map(modules, String), params.showInterface !== false, params.showAbstract !== false, String(params.targetType || ''));
  }
  /**
   * RPC to web:RegistryRpc.listTypes
   * @inner
   * @returns {Promise} promise to be resolved with an array of type info
   */


  function listTypesRpc(params) {
    return listTypes(params.batch, params.showInterface !== false, params.showAbstract !== false, params.targetType || '');
  }
  /**
   * Retrieve information on types.
   *
   * @inner
   * @param {Object} params
   * @param {Array.<String>} [params.modules] limit types to these modules
   * @returns {Promise} promise to be resolved with an array of type info
   */


  function getTypes(params) {
    var modules = params.modules;

    if (modules) {
      return listTypesForModulesRpc(modules, params).then(function (obj) {
        return _.flatten(_.map(modules, function (module) {
          return _.map(obj[module], _.clone);
        }));
      });
    } else {
      return listTypesRpc(params).then(function (arr) {
        return _.map(arr, _.clone);
      });
    }
  }

  function typeToJson(type) {
    var typeObj = {
      type: String(type),
      "super": String(type.getSuperType()),
      icon: String(type.getIcon()),
      displayName: 'TODO:',
      //TODO,
      interfaces: _.map(type.getInterfaces(), String)
    };

    if (type.getJsId()) {
      typeObj.js = {
        id: type.getJsId(),
        deps: type.getJsDependencies()
      };
    }

    return typeObj;
  }
  /**
   * Retrieve information directly about the given type specs.
   *
   * @inner
   * @param {Array.<String>} typeSpecs
   * @param {Object} [params]
   * @param {baja.comm.Batch} [params.batch]
   * @returns {Promise} promise to be resolved with typeSpec -> object mapping
   */


  function getTypeInfo(typeSpecs, params) {
    if (!typeSpecs.length) {
      return Promise.resolve({});
    }

    return baja.importTypes(_.extend({}, {
      typeSpecs: typeSpecs
    }, params)).then(function (types) {
      var obj = {};

      _.each(types, function (type) {
        obj[type] = typeToJson(type);
      });

      return obj;
    });
  }
  /**
   * Retrieve information about types registered as agents on the given
   * type specs.
   *
   * @inner
   * @param {Array.<String>} typeSpecs
   * @param {Object} [params]
   * @param {String} [params.is]
   * @param {baja.comm.Batch} [params.batch]
   * @returns {Promise.<Object>}
   */


  function getAgentOnInfo(typeSpecs, params) {
    if (!typeSpecs.length) {
      return Promise.resolve({});
    }

    var batch = params && params.batch,
        is = params && params.is,
        typeOrds = _.map(typeSpecs, function (t) {
      return 'type:' + t;
    });

    return baja.registry.getAgents(typeOrds, is ? [is] : undefined, batch).then(function (obj) {
      var o = {};

      _.each(obj, function (agentArr, ord) {
        o[ord.replace(/^type:/, '')] = _.map(agentArr, function (agentObj) {
          return typeToJson(baja.lt(agentObj.typeSpec));
        });
      });

      return o;
    });
  }
  /**
   * Filter the mixin info to only those that station is reporting as enabled.
   *
   * Since at the moment this is only used by manager views, and manager views
   * order their columns by enabled mixin order rather than agent registration
   * order (c.f. MgrModel#appendMixInColumns), this function will do so as well.
   * (If you go by agent registration order, Mobile Web Profile appears before
   * Default Web Profile - meaning momentary confusion for Workbench users.)
   *
   * @inner
   * @param {Array.<Type>} enabledMixins enabled mixin types as reported by
   * the station
   * @param {Array.<Object>} mixinInfos array of `baja:IMixIn` type info objects
   * @returns {Array.<Object>}
   */


  function onlyEnabledMixins(enabledMixins, mixinInfos) {
    enabledMixins = _.map(enabledMixins, String); //to type names

    return _.compact(_.map(enabledMixins, function (enabledMixin) {
      return _.find(mixinInfos, function (info) {
        return info.type === enabledMixin;
      });
    }));
  }
  /**
   * Resolve type info objects that are enabled `baja:IMixIn`s on
   * the requested type specs.
   *
   * @inner
   * @param {Array.<String|Type>} typeSpecs type specs we want the enabled
   * mixins on
   * @returns {Promise} promise to be resolved with an object literal: keys
   * are the requested type specs, values are arrays of type info objects for
   * the enabled mixins on that type
   */


  function getEnabledMixinsOn(typeSpecs) {
    var offline = baja.isOffline();
    return Promise.all([offline ? [] : baja.station.toEnabledMixIns(), offline ? {} : getAgentOnInfo(typeSpecs, {
      is: 'baja:IMixIn'
    })]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          enabledMixins = _ref2[0],
          agentResults = _ref2[1];

      var obj = {};

      _.each(typeSpecs, function (typeSpec) {
        var mixinInfos = agentResults && agentResults[typeSpec];
        obj[typeSpec] = onlyEnabledMixins(enabledMixins, mixinInfos || []);
      });

      return obj;
    });
  } ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * Queries the server for a list of installed modules. Returns an array of
   * objects, each with the following properties:
   *
   * - `n`: module name
   * - `d`: module description
   * - `v`: vendor name
   * - `vv`: vendor version (typically numeric, but returned as a string)
   *
   * @param {Object} [params]
   * @param {Boolean} [params.withTypesOnly=false] set to true to exclude
   * modules that do not have any Types that match the other parameters. (Not
   * setting this to `true` always means that all installed modules will be
   * returned.)
   * @param {String} [params.targetType] pass a type spec to only receive
   * modules that contain a type that is a subtype/implementation of that
   * type spec.
   * @param {Boolean} [params.showAbstract=true] set to `true` to include
   * modules that contain matching abstract types.
   * @param {Boolean} [params.showInterface=true] set to `true` to include
   * modules that contain matching interface types.
   * @returns {Promise} promise to be resolved with an array of objects
   * representing the requested modules.
   */


  exports.getModules = function (params) {
    return listModulesRpc(params || {}).then(coalesceModules);
  };
  /**
   * Queries the server for a list of types for the requested modules. Returns
   * an array of objects, each with the following properties:
   *
   * - `type`: the actual type spec of the type
   * - `super`: the type spec of the type's supertype
   * - `interfaces`: an array of type specs representing the interfaces the
   *   type implements
   * - `displayName`: the type's display name
   * - `icon`: a URI to an image file representing the type's icon
   *
   * @param {Object} [params]
   * @param {Array.<String>} [params.modules] if given, limit types to those
   * contained in these modules (names, not part names)
   * @param {String} [params.targetType] pass a type spec to only receive
   * types that are a subtype/implementation of that type spec.
   * @param {Boolean} [params.showAbstract=true] set to `true` to include
   * matching abstract types.
   * @param {Boolean} [params.showInterface=true] set to `true` to include
   * matching interface types.
   * @returns {Promise} promise to be resolved with an array of objects
   * representing the requested types.
   */


  exports.getTypes = function (params) {
    return getTypes(params || {});
  };
  /**
   * Retrieve information from the registry servlet about the given type specs.
   * If a single type spec is given, a single object will be resolved; if an
   * array of type specs is given, an array of objects will be resolved.
   *
   * Each object will have some or all of the following properties:
   *
   * - `super`: supertype string
   * - `interfaces`: array of implemented `BInterface`s
   * - `displayName`: display name string
   * - `icon`: icon URI
   * - `js`: if appropriate, `BIJavaScript` information: `deps` (dependency
   *   IDs), `id`: AMD module ID
   * - `type`: type spec string
   *
   * @param {String|Array.<String>} typeSpecs
   * @param {Object} [params]
   * @param {baja.comm.Batch} [params.batch] batch for type resolution
   * @returns {Promise} promise to be resolved with an object, or array
   * of objects
   */


  exports.getTypeInfo = function (typeSpecs, params) {
    return handleSingleOrArray(typeSpecs, getTypeInfo, [params]);
  };
  /**
   * Retrieve information from the registry servlet about type specs that are
   * registered as agents on the given type specs. If a single type spec is
   * given, an array of objects will be resolved; if an array of type specs
   * is given, an array of arrays of objects will be resolved.
   *
   * Each object will have the same properties as those returned by
   * `getTypeInfo`.
   *
   * @param {String|Array.<String>} typeSpecs
   * @param {Object} [params]
   * @param {String} [params.is] if given, only return info on agents that are
   * of the given type
   * @param {baja.comm.Batch} [params.batch] if given, the network request will
   * use this batch
   * @returns {Promise} promise to be resolved with an array, or array
   * of arrays
   */


  exports.getAgentOnInfo = function (typeSpecs, params) {
    return handleSingleOrArray(typeSpecs, getAgentOnInfo, [params]);
  };
  /**
   * Retrieve information from the registry servlet about type specs that are
   * enabled mixins on the given type. This will query the servlet for all
   * agents registered on the given type, and filter out those that are not
   * `IMixIn`s currently enabled on the component space.
   *
   * If a single type spec is given, an array of objects will be resolved; if
   * an array of type specs is given, an array of arrays of objects will be
   * resolved.
   *
   * Each object will have the same properties as those returned by
   * `getTypeInfo`.
   *
   * Note that mixins are only available when a station is running. If
   * BajaScript is offline, then only empty arrays will be resolved.
   *
   * @param typeSpecs
   * @returns {Promise}
   */


  exports.getEnabledMixinsOn = function (typeSpecs) {
    return handleSingleOrArray(typeSpecs, getEnabledMixinsOn);
  };

  exports.$clearMemoization = function () {
    listModules.cache = {};
    listTypesForModules.cache = {};
    listTypes.cache = {};
  };

  return exports;
});
