/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*eslint strict: "OFF" */

/**
 * API Status: **Private**
 *
 * A Handlebars block helper function for processing `Facets` values. The block
 * will be evaluated once per key with `key`, `type`, and `value` values.
 * Note that `value` is the string encoding of the value and not the value
 * itself.
 *
 * Auto-registers as `facets` helper on `Handlebars` upon requiring this module.
 *
 * @module nmodule/webEditors/rc/helpers/facetsHelper
 * @example
 *   var tpl = Handlebars.compile(
 *     '{{#facets facets}}' +
 *       'key: {{key}} ' +
 *       'type: {{type}} ' +
 *       'value: {{value}}\n' +
 *     '{{/facets}}'
 *   );
 *   console.log(tpl({ facets: baja.Facets.make({}) }));
 */
define(['underscore', 'Handlebars'], function (_, Handlebars) {
  function facetsHelper(facets, options) {
    if (!facets) {
      return options.inverse();
    }

    var that = this,
        fn = options.fn,
        keys = facets.getKeys(),
        out = '',
        _key = that.key,
        _type = that.type,
        _value = that.value;

    _.each(keys, function (key) {
      var value = facets.get(key);
      that.key = key;
      that.type = value.getType();
      that.value = value.encodeToString();
      out += fn(that);
    }); //restore original state


    that.key = _key;
    that.type = _type;
    that.value = _value;
    return out;
  }

  Handlebars.registerHelper('facets', facetsHelper);
  return facetsHelper;
});
